/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.tracecontrol.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TargetResource;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class ProviderResource
extends AbstractResource {
    private String fName;
    private TargetResource[] fTargets;

    public ProviderResource() {
    }

    public ProviderResource(ISubSystem parentSubSystem) {
        super(parentSubSystem);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public TargetResource[] getTargets() {
        Arrays.sort(this.fTargets);
        return this.fTargets;
    }

    public boolean isUst() {
        return this.fName.equals("ust");
    }

    public void setTargets(TargetResource[] newTargets) {
        this.fTargets = newTargets;
    }

    public void removeAllTargets() {
        int i = 0;
        while (i < this.fTargets.length) {
            this.fTargets[i].removeAllTraces();
            ++i;
        }
        this.fTargets = null;
    }

    public void refreshTargets(TargetResource[] otherTargets) {
        ArrayList<TargetResource> newTargets = new ArrayList<TargetResource>();
        int i = 0;
        while (i < otherTargets.length) {
            boolean added = false;
            int j = 0;
            while (j < this.fTargets.length) {
                if (otherTargets[i].equals(this.fTargets[j])) {
                    newTargets.add(this.fTargets[j]);
                    this.fTargets[j].refreshTraces(otherTargets[i].getTraces());
                    added = true;
                    break;
                }
                ++j;
            }
            if (!added) {
                newTargets.add(otherTargets[i]);
            }
            ++i;
        }
        this.fTargets = newTargets.toArray(new TargetResource[0]);
    }

    public String toString() {
        return "[ProviderResource (" + this.fName + ")]";
    }
}

