/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof.view.fields;

import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTDataViewersField;
import org.eclipse.linuxtools.dataviewers.charts.provider.IChartField;
import org.eclipse.linuxtools.gprof.view.GmonView;
import org.eclipse.linuxtools.gprof.view.histogram.CGArc;
import org.eclipse.linuxtools.gprof.view.histogram.CGCategory;
import org.eclipse.linuxtools.gprof.view.histogram.HistFunction;
import org.eclipse.linuxtools.gprof.view.histogram.HistRoot;
import org.eclipse.linuxtools.gprof.view.histogram.TreeElement;
import org.eclipse.swt.graphics.Color;

public class CallsProfField
extends AbstractSTDataViewersField
implements IChartField {
    public int compare(Object obj1, Object obj2) {
        TreeElement e1 = (TreeElement)obj1;
        TreeElement e2 = (TreeElement)obj2;
        int s1 = e1.getCalls();
        int s2 = e2.getCalls();
        return s1 - s2;
    }

    public String getColumnHeaderText() {
        return "Calls";
    }

    public String getColumnHeaderTooltip() {
        return null;
    }

    public String getToolTipText(Object element) {
        if (element instanceof HistRoot) {
            return "total number of function call";
        }
        if (element instanceof HistFunction) {
            return "number of times the function \"" + ((HistFunction)element).getName() + "\" was invoked";
        }
        if (element instanceof CGCategory) {
            CGCategory cat = (CGCategory)element;
            if ("children".equals(cat.getName())) {
                return "number of function call performed by the function \"" + cat.getParent().getName() + "\"";
            }
            return "number of times the function \"" + cat.getParent().getName() + "\" was invoked";
        }
        if (element instanceof CGArc) {
            CGArc cgarc = (CGArc)element;
            if ("children".equals(cgarc.getParent().getName())) {
                return "number of times the function \"" + cgarc.getParent().getParent().getName() + "\" called the function \"" + cgarc.getFunctionName() + "\"";
            }
            return "number of times the function \"" + cgarc.getFunctionName() + "\" called the function \"" + cgarc.getParent().getParent().getName() + "\"";
        }
        return null;
    }

    public String getValue(Object obj) {
        TreeElement e = (TreeElement)obj;
        int i = e.getCalls();
        if (i == -1) {
            return "";
        }
        String ret = String.valueOf(i);
        return ret;
    }

    public Color getBackground(Object element) {
        return GmonView.getBackground(element);
    }

    public Number getNumber(Object obj) {
        TreeElement e = (TreeElement)obj;
        int i = e.getCalls();
        if (i == -1) {
            return 0L;
        }
        return i;
    }
}

