/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.json.jsonpath.IJSONPath;
import org.eclipse.json.jsonpath.JSONPath;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.ui.contentassist.ContentAssistRequest;
import org.eclipse.wst.json.ui.contentassist.ICompletionProposalCollector;
import org.eclipse.wst.json.ui.internal.JSONUIPlugin;
import org.eclipse.wst.json.ui.internal.Logger;
import org.eclipse.wst.json.ui.internal.contentassist.CompletionProposalMatcher;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;

public class CompletionProposalCollectorsRegistryReader {
    protected static final String EXTENSION_POINT_ID = "completionProposalCollectors";
    protected static final String TAG_CONTRIBUTION = "completionProposalCollector";
    public static CompletionProposalCollectorsRegistryReader INSTANCE = null;
    private final Map<String, Collection<CompletionProposalMatcher>> matchers = new HashMap<String, Collection<CompletionProposalMatcher>>();

    public static CompletionProposalCollectorsRegistryReader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CompletionProposalCollectorsRegistryReader();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public void addProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, ICompletionProposalCollector.TargetType target) {
        IJSONNode node = contentAssistRequest.getNode();
        String contentTypeId = node.getModel().getContentTypeIdentifier();
        Collection<CompletionProposalMatcher> matchersByContentType = this.matchers.get(contentTypeId);
        if (matchersByContentType != null) {
            for (CompletionProposalMatcher matcher : matchersByContentType) {
                matcher.addProposalsIfMatch(contentAssistRequest, context, target);
            }
        }
    }

    protected void readRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(JSONUIPlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    protected void readElement(IConfigurationElement element) {
        if (TAG_CONTRIBUTION.equals(element.getName())) {
            try {
                ICompletionProposalCollector collector = (ICompletionProposalCollector)element.createExecutableExtension("class");
                JSONPath[] paths = this.createPaths(element.getAttribute("paths"));
                Collection<ICompletionProposalCollector.TargetType> targets = this.createTargets(element.getAttribute("targets"));
                String contentTypeId = element.getAttribute("contentTypeId");
                CompletionProposalMatcher matcher = new CompletionProposalMatcher(targets, (IJSONPath[])paths, collector);
                Collection<CompletionProposalMatcher> matchersByContentType = this.matchers.get(contentTypeId);
                if (matchersByContentType == null) {
                    matchersByContentType = new ArrayList<CompletionProposalMatcher>();
                    this.matchers.put(contentTypeId, matchersByContentType);
                }
                matchersByContentType.add(matcher);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    private JSONPath[] createPaths(String value) {
        String[] s = value.split(",");
        JSONPath[] paths = new JSONPath[s.length];
        int i = 0;
        while (i < s.length) {
            paths[i] = new JSONPath(s[i].trim());
            ++i;
        }
        return paths;
    }

    private Collection<ICompletionProposalCollector.TargetType> createTargets(String value) {
        String[] s = value.split(",");
        ArrayList<ICompletionProposalCollector.TargetType> targets = new ArrayList<ICompletionProposalCollector.TargetType>();
        int i = 0;
        while (i < s.length) {
            targets.add(ICompletionProposalCollector.TargetType.valueOf(s[i].trim()));
            ++i;
        }
        return targets;
    }
}

