/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api.query;

import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.query.MethodQuery;
import org.eclipse.scout.sdk.core.java.model.api.spliterator.HierarchicalStreamBuilder;
import org.eclipse.scout.sdk.core.model.query.AbstractQuery;

public class SuperMethodQuery
extends AbstractQuery<IMethod> {
    private final IMethod m_method;
    private final String m_methodId;
    private boolean m_includeSelf = true;
    private boolean m_includeSuperClasses = true;
    private boolean m_includeSuperInterfaces = true;

    public SuperMethodQuery(IMethod method) {
        this.m_method = method;
        this.m_methodId = method.identifier();
    }

    protected String getMethodIdentifier() {
        return this.m_methodId;
    }

    protected IMethod getMethod() {
        return this.m_method;
    }

    public SuperMethodQuery withSelf(boolean b) {
        this.m_includeSelf = b;
        return this;
    }

    protected boolean isIncludeSelf() {
        return this.m_includeSelf;
    }

    public SuperMethodQuery withSuperTypes(boolean b) {
        this.m_includeSuperClasses = b;
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public SuperMethodQuery withSuperClasses(boolean b) {
        this.m_includeSuperClasses = b;
        return this;
    }

    protected boolean isIncludeSuperClasses() {
        return this.m_includeSuperClasses;
    }

    public SuperMethodQuery withSuperInterfaces(boolean b) {
        this.m_includeSuperInterfaces = b;
        return this;
    }

    protected boolean isIncludeSuperInterfaces() {
        return this.m_includeSuperInterfaces;
    }

    protected Stream<IMethod> createStream() {
        return new HierarchicalStreamBuilder().withStartType(this.isIncludeSelf()).withSuperClasses(this.isIncludeSuperClasses()).withSuperInterfaces(this.isIncludeSuperInterfaces()).build(this.getMethod().requireDeclaringType(), level -> MethodQuery.findMatchingMethods(level, this.getMethodIdentifier()));
    }
}

