/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api.internal;

import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.generator.compilationunit.CompilationUnitGenerator;
import org.eclipse.scout.sdk.core.java.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.java.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.java.model.api.IImport;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.api.IPackage;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.internal.AbstractJavaElementImplementor;
import org.eclipse.scout.sdk.core.java.model.api.query.InnerTypeQuery;
import org.eclipse.scout.sdk.core.java.model.api.spliterator.WrappingSpliterator;
import org.eclipse.scout.sdk.core.java.model.spi.ClasspathSpi;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class CompilationUnitImplementor
extends AbstractJavaElementImplementor<CompilationUnitSpi>
implements ICompilationUnit {
    public CompilationUnitImplementor(CompilationUnitSpi spi) {
        super(spi);
    }

    @Override
    public boolean isSynthetic() {
        return ((CompilationUnitSpi)this.m_spi).isSynthetic();
    }

    @Override
    public IPackage containingPackage() {
        return ((CompilationUnitSpi)this.m_spi).getPackage().wrap();
    }

    @Override
    public Optional<IClasspathEntry> containingClasspathFolder() {
        return Optional.ofNullable(((CompilationUnitSpi)this.m_spi).getContainingClasspathFolder()).map(ClasspathSpi::wrap);
    }

    @Override
    public Optional<IType> resolveTypeBySimpleName(String simpleName) {
        return Optional.ofNullable(((CompilationUnitSpi)this.m_spi).findTypeBySimpleName(simpleName)).map(TypeSpi::wrap);
    }

    @Override
    public Stream<? extends IJavaElement> children() {
        Stream<IImport> packageAndImports = Stream.concat(Stream.of(this.containingPackage()), this.imports());
        return Stream.concat(packageAndImports, this.types().stream());
    }

    @Override
    public Optional<Path> absolutePath() {
        return Optional.ofNullable(((CompilationUnitSpi)this.m_spi).absolutePath());
    }

    @Override
    public Optional<IType> mainType() {
        return Optional.ofNullable(((CompilationUnitSpi)this.m_spi).getMainType()).map(TypeSpi::wrap);
    }

    @Override
    public IType requireMainType() {
        return this.mainType().orElseThrow(() -> Ensure.newFail((CharSequence)"Compilation Unit '{}' has no main type.", (Object[])new Object[]{this.path()}));
    }

    @Override
    public Path path() {
        return this.containingPackage().asPath().resolve(this.elementName());
    }

    @Override
    public Stream<IImport> imports() {
        return WrappingSpliterator.stream(((CompilationUnitSpi)this.m_spi).getImports());
    }

    @Override
    public Optional<SourceRange> javaDoc() {
        return Optional.ofNullable(((CompilationUnitSpi)this.m_spi).getJavaDoc());
    }

    @Override
    public InnerTypeQuery types() {
        return new InnerTypeQuery(new WrappingSpliterator<IType>(((CompilationUnitSpi)this.m_spi).getTypes()));
    }

    @Override
    public ICompilationUnitGenerator<?> toWorkingCopy(IWorkingCopyTransformer transformer) {
        return CompilationUnitGenerator.create(this, transformer);
    }

    @Override
    public ICompilationUnitGenerator<?> toWorkingCopy() {
        return this.toWorkingCopy(null);
    }

    @Override
    public String toString() {
        return this.mainType().map(IType::name).map(fqn -> fqn + ".java").orElseGet(this::elementName);
    }
}

