/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.spi;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;
import org.eclipse.scout.sdk.core.typescript.model.api.internal.ES6ClassImplementor;
import org.eclipse.scout.sdk.core.typescript.model.spi.AbstractNodeElementSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.DataTypeSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.ES6ClassSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.FunctionSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class ES6ClassWithTypeArgumentsSpi
extends AbstractNodeElementSpi<IES6Class>
implements ES6ClassSpi {
    private final ES6ClassSpi m_class;
    private final List<DataTypeSpi> m_arguments;

    protected ES6ClassWithTypeArgumentsSpi(NodeModuleSpi module, ES6ClassSpi classSpi, List<DataTypeSpi> typeArguments) {
        super(module);
        this.m_class = classSpi;
        this.m_arguments = Collections.unmodifiableList(new ArrayList<DataTypeSpi>(typeArguments));
    }

    @Override
    public INodeElement.ExportType exportType() {
        return INodeElement.ExportType.NONE;
    }

    @Override
    protected Path resolveContainingFile() {
        return null;
    }

    @Override
    public ES6ClassSpi withoutTypeArguments() {
        return this.m_class;
    }

    @Override
    public boolean hasModifier(Modifier modifier) {
        return this.m_class.hasModifier(modifier);
    }

    @Override
    public String name() {
        return this.m_class.name();
    }

    @Override
    public Collection<DataTypeSpi> childTypes() {
        return this.m_class.childTypes();
    }

    @Override
    protected IES6Class createApi() {
        return new ES6ClassImplementor(this);
    }

    @Override
    public Optional<SourceRange> source() {
        return this.m_class.source();
    }

    @Override
    public boolean isEnum() {
        return this.m_class.isEnum();
    }

    @Override
    public boolean isTypeAlias() {
        return this.m_class.isTypeAlias();
    }

    @Override
    public Optional<DataTypeSpi> aliasedDataType() {
        return this.m_class.aliasedDataType();
    }

    @Override
    public List<FieldSpi> fields() {
        return this.m_class.fields();
    }

    @Override
    public List<FunctionSpi> functions() {
        return this.m_class.functions();
    }

    @Override
    public List<DataTypeSpi> typeArguments() {
        return this.m_arguments;
    }

    @Override
    public List<TypeParameterSpi> typeParameters() {
        return Collections.emptyList();
    }

    @Override
    public DataTypeSpi createDataType(String name) {
        return this.m_class.createDataType(name);
    }

    public boolean isInterface() {
        return this.m_class.isInterface();
    }

    public Optional<ES6ClassSpi> superClass() {
        return this.m_class.superClass();
    }

    public Stream<ES6ClassSpi> superInterfaces() {
        return this.m_class.superInterfaces();
    }
}

