/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api.internal;

import java.util.Optional;
import org.eclipse.scout.sdk.core.typescript.model.api.IConstantValue;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.typescript.model.api.JsonPointer;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class ConstantValuePointerElement
implements JsonPointer.IJsonPointerElement {
    private final IConstantValue m_value;
    private final FinalValue<Optional<IConstantValue[]>> m_asArray;
    private final FinalValue<Optional<IObjectLiteral>> m_asObject;

    ConstantValuePointerElement(IConstantValue value) {
        this.m_value = value;
        this.m_asArray = new FinalValue();
        this.m_asObject = new FinalValue();
    }

    @Override
    public int arrayLength() {
        Optional<IConstantValue[]> asArray = this.asArray();
        if (asArray.isPresent()) {
            return asArray.orElseThrow().length;
        }
        return 0;
    }

    @Override
    public boolean isObject() {
        return this.asObject().isPresent();
    }

    @Override
    public JsonPointer.IJsonPointerElement element(String name) {
        return this.asObject().orElseThrow().property(name).map(ConstantValuePointerElement::new).orElse(null);
    }

    @Override
    public JsonPointer.IJsonPointerElement element(int index) {
        return this.asArray().filter(e -> index < ((IConstantValue[])e).length).map(e -> e[index]).map(ConstantValuePointerElement::new).orElse(null);
    }

    protected Optional<IObjectLiteral> asObject() {
        return (Optional)this.m_asObject.computeIfAbsentAndGet(this.m_value::asObjectLiteral);
    }

    protected Optional<IConstantValue[]> asArray() {
        return (Optional)this.m_asArray.computeIfAbsentAndGet(() -> this.m_value.convertTo(IConstantValue[].class));
    }

    public IConstantValue getValue() {
        return this.m_value;
    }
}

