/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls;

import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.sdk.core.util.Ensure;

public final class Language
implements Comparable<Language> {
    public static final String LANGUAGE_REGEX = "([^_]+)(?:_([^_]+))?(?:_(.+))?";
    public static final Language LANGUAGE_DEFAULT = new Language(Locale.of("default"));
    private static final Pattern LANGUAGE_PATTERN = Pattern.compile("^([^_]+)(?:_([^_]+))?(?:_(.+))?$");
    private final Locale m_locale;
    private final String m_displayName;

    public Language(Locale locale) {
        this.m_locale = (Locale)Ensure.notNull((Object)locale);
        this.m_displayName = this.m_locale.getDisplayName(Locale.US);
    }

    public Locale locale() {
        return this.m_locale;
    }

    public String displayName() {
        return this.m_displayName;
    }

    public int hashCode() {
        return this.displayName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Language other = (Language)obj;
        return this.displayName().equals(other.displayName());
    }

    public String toString() {
        return this.displayName();
    }

    public static Language parseThrowingOnError(CharSequence name) {
        return Language.parse(name).orElseThrow(() -> Ensure.newFail((CharSequence)"Invalid language name '{}'. Language cannot be parsed.", (Object[])new Object[]{name}));
    }

    public static Optional<Language> parse(CharSequence name) {
        Matcher matcher = LANGUAGE_PATTERN.matcher(name);
        if (matcher.matches()) {
            String variantIso;
            if (matcher.group(2) == null && LANGUAGE_DEFAULT.locale().toString().equals(matcher.group(1))) {
                return Optional.of(LANGUAGE_DEFAULT);
            }
            String languageIso = matcher.group(1);
            String countryIso = matcher.group(2);
            if (countryIso == null) {
                countryIso = "";
            }
            if ((variantIso = matcher.group(3)) == null) {
                variantIso = "";
            } else if (variantIso.startsWith("_")) {
                variantIso = variantIso.substring(1);
            }
            return Optional.of(new Language(Locale.of(languageIso, countryIso, variantIso)));
        }
        return Optional.empty();
    }

    @Override
    public int compareTo(Language o) {
        if (o == this) {
            return 0;
        }
        if (this == LANGUAGE_DEFAULT) {
            return -1;
        }
        if (o == LANGUAGE_DEFAULT) {
            return 1;
        }
        return this.displayName().compareTo(o.displayName());
    }
}

