/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.jaxws;

import java.util.Optional;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.util.Strings;

public class JaxbBindingGenerator
implements ISourceGenerator<ISourceBuilder<?>> {
    private String m_jaxBNamespace;
    private String m_jaxBVersion;

    public void generate(ISourceBuilder<?> builder) {
        String jaxBNamespace = this.jaxBNamespace().orElseThrow();
        String jaxBVersion = this.jaxBVersion().orElseThrow();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>").nl();
        builder.append("<!-- binding to customize xsd schema artifacts (jaxb-namespace: ").append(jaxBNamespace).append(") -->").nl();
        builder.append("<bindings xmlns=\"").append(jaxBNamespace).append("\" version=\"").append(jaxBVersion).append("\">").nl();
        builder.append("</bindings>").nl();
    }

    public Optional<String> jaxBNamespace() {
        return Strings.notBlank((CharSequence)this.m_jaxBNamespace);
    }

    public JaxbBindingGenerator withJaxBNamespace(String jaxBNamespace) {
        this.m_jaxBNamespace = jaxBNamespace;
        return this;
    }

    public Optional<String> jaxBVersion() {
        return Strings.notBlank((CharSequence)this.m_jaxBVersion);
    }

    public JaxbBindingGenerator withJaxBVersion(String jaxBVersion) {
        this.m_jaxBVersion = jaxBVersion;
        return this;
    }
}

