/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizardPage;
import org.eclipse.scout.sdk.s2e.ui.wizard.WizardFinishTask;

public abstract class AbstractWizard
extends Wizard {
    protected AbstractWizard() {
        this.setDialogSettings(S2ESdkUiActivator.getDefault().getDialogSettingsSection(this.getDialogSettingsKey()));
    }

    public boolean performFinish() {
        if (!this.allPagesCanFinish()) {
            return false;
        }
        EclipseEnvironment.runInEclipseEnvironment(this.getFinishTask());
        return true;
    }

    public abstract WizardFinishTask<?> getFinishTask();

    protected boolean allPagesCanFinish() {
        return Arrays.stream(this.getPages()).filter(page -> page instanceof AbstractWizardPage).map(page -> (AbstractWizardPage)((Object)page)).allMatch(AbstractWizardPage::performFinish);
    }

    protected String getDialogSettingsKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected static <T extends AbstractWizardPage> T createWizardPage(Class<T> pageClass, PackageContainer packageContainer) {
        try {
            return (T)((Object)((AbstractWizardPage)((Object)pageClass.getConstructor(PackageContainer.class).newInstance(packageContainer))));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected <T extends AbstractWizardPage> T initNewClassWizardWithPage(Class<T> pageClass, PackageContainer packageContainer) {
        T page = AbstractWizard.createWizardPage(pageClass, packageContainer);
        this.addPage((IWizardPage)page);
        this.setWindowTitle(page.getTitle());
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        return page;
    }

    public void addPage(IWizardPage page) {
        if (!(page instanceof AbstractWizardPage)) {
            throw new IllegalArgumentException("Expecting an instance of '" + AbstractWizardPage.class.getName() + "'.");
        }
        super.addPage(page);
    }

    public AbstractWizardPage getPage(String name) {
        return (AbstractWizardPage)super.getPage(name);
    }

    public IWizardPage getStartingPage() {
        AbstractWizardPage startingPage = (AbstractWizardPage)super.getStartingPage();
        if (startingPage != null && startingPage.isExcludePage()) {
            return this.getNextPage((IWizardPage)startingPage);
        }
        return startingPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        List<IWizardPage> pages = Arrays.asList(this.getPages());
        int index = pages.indexOf(page);
        if (index == pages.size() - 1 || index == -1) {
            return null;
        }
        AbstractWizardPage nextPage = (AbstractWizardPage)pages.get(index + 1);
        if (nextPage.isExcludePage()) {
            return this.getNextPage((IWizardPage)nextPage);
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        AbstractWizardPage prevPage = (AbstractWizardPage)super.getPreviousPage(page);
        if (prevPage != null && prevPage.isExcludePage()) {
            return this.getPreviousPage((IWizardPage)prevPage);
        }
        return prevPage;
    }

    public boolean canFinish() {
        return Arrays.stream(this.getPages()).map(page -> (AbstractWizardPage)((Object)page)).noneMatch(bcPage -> !bcPage.isExcludePage() && !bcPage.isPageComplete());
    }
}

