/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.EventListenerList;

public class PropertySupport {
    private final Map<String, Object> m_props;
    private final Object m_source;
    private EventListenerList m_listeners;
    private Map<String, EventListenerList> m_childListeners;

    public PropertySupport() {
        this(null);
    }

    public PropertySupport(Object source) {
        this.m_source = Objects.requireNonNullElse(source, this);
        this.m_props = new HashMap<String, Object>();
    }

    public PropertySupport(int size) {
        this(null, size);
    }

    public PropertySupport(Object source, int size) {
        this.m_source = Objects.requireNonNullElse(source, this);
        this.m_props = new HashMap<String, Object>(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getPropertiesMap() {
        Map<String, Object> map = this.m_props;
        synchronized (map) {
            return new HashMap<String, Object>(this.m_props);
        }
    }

    public boolean hasProperty(String name) {
        return this.m_props.containsKey(name);
    }

    public int size() {
        return this.m_props.size();
    }

    public boolean setPropertyInt(String name, int i) {
        return this.setProperty(name, i);
    }

    public int getPropertyInt(String name, int defaultValue) {
        Number n = this.getProperty(name, Number.class);
        if (n == null) {
            return defaultValue;
        }
        return n.intValue();
    }

    public boolean setPropertyDouble(String name, double d) {
        return this.setProperty(name, d);
    }

    public double getPropertyDouble(String name, double defaultValue) {
        Number n = this.getProperty(name, Number.class);
        if (n == null) {
            return defaultValue;
        }
        return n.doubleValue();
    }

    public boolean setPropertyLong(String name, long i) {
        return this.setProperty(name, i);
    }

    public long getPropertyLong(String name, long defaultValue) {
        Number n = this.getProperty(name, Number.class);
        if (n == null) {
            return defaultValue;
        }
        return n.longValue();
    }

    public boolean setPropertyBool(String name, boolean b) {
        return this.setProperty(name, b);
    }

    public boolean getPropertyBool(String name, boolean defaultValue) {
        Boolean b = this.getProperty(name, Boolean.class);
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    public boolean setPropertyString(String name, String s) {
        return this.setProperty(name, s);
    }

    public String getPropertyString(String name) {
        return this.getProperty(name, String.class);
    }

    public <T> T getProperty(String name, Class<T> type) {
        return type.cast(this.m_props.get(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setProperty(String name, Object newValue) {
        Object oldValue;
        Ensure.notBlank(name);
        Map<String, Object> map = this.m_props;
        synchronized (map) {
            oldValue = newValue == null ? this.m_props.remove(name) : this.m_props.put(name, newValue);
        }
        return this.firePropertyChange(name, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T removeProperty(String name, Class<T> type) {
        Map<String, Object> map = this.m_props;
        synchronized (map) {
            return type.cast(this.m_props.remove(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T computeIfAbsent(String name, Function<String, T> valueProvider) {
        Map<String, Object> map = this.m_props;
        synchronized (map) {
            return (T)this.m_props.computeIfAbsent(name, valueProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.addPropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
            return;
        }
        Map<String, Object> map = this.m_props;
        synchronized (map) {
            if (this.m_listeners == null) {
                this.m_listeners = new EventListenerList();
            }
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            return this.removePropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        }
        Map<String, Object> map = this.m_props;
        synchronized (map) {
            boolean removed = false;
            if (this.m_listeners != null) {
                removed = this.m_listeners.remove(listener);
                if (this.m_listeners.isEmpty()) {
                    this.m_listeners = null;
                }
            }
            if (this.m_childListeners != null) {
                Iterator<EventListenerList> iterator = this.m_childListeners.values().iterator();
                while (iterator.hasNext()) {
                    EventListenerList list = iterator.next();
                    if (!list.remove(listener) || !list.isEmpty()) continue;
                    iterator.remove();
                    removed = true;
                }
                if (this.m_childListeners.isEmpty()) {
                    this.m_childListeners = null;
                }
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Ensure.notBlank(propertyName);
        Ensure.notNull(listener);
        Map<String, Object> map = this.m_props;
        synchronized (map) {
            if (this.m_childListeners == null) {
                this.m_childListeners = new HashMap<String, EventListenerList>();
            }
            this.m_childListeners.computeIfAbsent(propertyName, (? super K key) -> new EventListenerList()).add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Ensure.notBlank(propertyName);
        Ensure.notNull(listener);
        Map<String, Object> map = this.m_props;
        synchronized (map) {
            if (this.m_childListeners == null) {
                return false;
            }
            EventListenerList childList = this.m_childListeners.get(propertyName);
            boolean removed = childList.remove(listener);
            if (removed && childList.isEmpty()) {
                this.m_childListeners.remove(propertyName);
                if (this.m_childListeners.isEmpty()) {
                    this.m_childListeners = null;
                }
            }
            return removed;
        }
    }

    public boolean firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (Objects.equals(oldValue, newValue)) {
            return false;
        }
        PropertyChangeEvent e = new PropertyChangeEvent(this.m_source, propertyName, oldValue, newValue);
        this.firePropertyChange(e);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(PropertyChangeEvent e) {
        if (e == null) {
            return;
        }
        ArrayList<PropertyChangeListener> targets = new ArrayList<PropertyChangeListener>();
        String propertyName = e.getPropertyName();
        Map<String, Object> map = this.m_props;
        synchronized (map) {
            EventListenerList propertyListenerList;
            if (this.m_listeners != null) {
                if (this.m_listeners.isEmpty()) {
                    this.m_listeners = null;
                } else {
                    targets.addAll(this.m_listeners.get(PropertyChangeListener.class));
                }
            }
            if (propertyName != null && this.m_childListeners != null && (propertyListenerList = this.m_childListeners.get(propertyName)) != null) {
                targets.addAll(propertyListenerList.get(PropertyChangeListener.class));
            }
        }
        if (targets.isEmpty()) {
            return;
        }
        for (PropertyChangeListener listener : targets) {
            listener.propertyChange(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.m_props.hashCode();
        result = prime * result + (this.m_source == this ? 0 : this.m_source.hashCode());
        return result;
    }

    protected boolean isSourceThis() {
        return this.m_source == this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PropertySupport other = (PropertySupport)obj;
        if (!this.m_props.equals(other.m_props)) {
            return false;
        }
        if (this.isSourceThis() != other.isSourceThis()) {
            return false;
        }
        if (this.isSourceThis()) {
            return true;
        }
        return Objects.equals(this.m_source, other.m_source);
    }
}

