/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.control;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Text;
import org.eclipse.terminal.control.ICommandInputField;
import org.eclipse.terminal.control.ITerminalViewControl;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class CommandInputFieldWithHistory
implements ICommandInputField {
    final List<String> fHistory = new ArrayList<String>();
    List<Object> fEditedHistory;
    private int fEditHistoryPos = 0;
    private final int fMaxSize;
    private Text fInputField;
    private Sash fSash;
    private Composite fPanel;

    public CommandInputFieldWithHistory(int maxHistorySize) {
        this.fMaxSize = maxHistorySize;
    }

    protected void pushLine(String line) {
        this.endHistoryMode();
        if (line == null || line.trim().length() == 0) {
            return;
        }
        this.fHistory.add(0, line);
        if (this.fHistory.size() > 1 && line.equals(this.fHistory.get(1))) {
            this.fHistory.remove(0);
        }
        if (this.fHistory.size() >= this.fMaxSize) {
            this.fHistory.remove(this.fHistory.size() - 1);
        }
    }

    public void setHistory(String history) {
        this.endHistoryMode();
        this.fHistory.clear();
        if (history == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(history, "\n");
        while (tok.hasMoreElements()) {
            this.fHistory.add((String)tok.nextElement());
        }
    }

    public String getHistory() {
        StringBuffer buff = new StringBuffer();
        boolean sep = false;
        for (String line : this.fHistory) {
            if (line.length() <= 0) continue;
            if (sep) {
                buff.append("\n");
            } else {
                sep = true;
            }
            buff.append(line);
        }
        return buff.toString();
    }

    public String move(String currLine, int count) {
        if (!this.inHistoryMode()) {
            this.fEditedHistory = new ArrayList<Object>(this.fHistory.size() + 1);
            this.fEditedHistory.add(currLine);
            this.fEditedHistory.addAll(this.fHistory);
            this.fEditHistoryPos = 0;
        }
        this.fEditedHistory.set(this.fEditHistoryPos, currLine);
        if (this.fEditHistoryPos + count >= this.fEditedHistory.size()) {
            return null;
        }
        if (this.fEditHistoryPos + count < 0) {
            return null;
        }
        this.fEditHistoryPos += count;
        return (String)this.fEditedHistory.get(this.fEditHistoryPos);
    }

    private boolean inHistoryMode() {
        return this.fEditedHistory != null;
    }

    protected String escape() {
        if (!this.inHistoryMode()) {
            return null;
        }
        String line = (String)this.fEditedHistory.get(0);
        this.endHistoryMode();
        return line;
    }

    private void endHistoryMode() {
        this.fEditedHistory = null;
        this.fEditHistoryPos = 0;
    }

    @Override
    public void createControl(Composite parent, final ITerminalViewControl terminal) {
        this.fSash = new Sash(parent, 256);
        GridData gd_sash = new GridData(4, 0x1000000, true, false);
        gd_sash.heightHint = 5;
        this.fSash.setLayoutData((Object)gd_sash);
        this.fSash.addListener(13, e -> {
            if (e.detail == 1) {
                return;
            }
            GridData gdata = (GridData)this.fInputField.getLayoutData();
            Rectangle sashRect = this.fSash.getBounds();
            Rectangle containerRect = parent.getClientArea();
            int h = this.fInputField.getLineHeight();
            gdata.heightHint = Math.max((containerRect.height - e.y - sashRect.height) / h * h, h);
            e.y = Math.min(e.y, containerRect.height - h);
            this.fInputField.setLayoutData((Object)gdata);
            parent.layout();
            parent.redraw();
        });
        this.fPanel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 2;
        this.fPanel.setLayout((Layout)layout);
        this.fPanel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fInputField = new Text(this.fPanel, 2626);
        GridData data = new GridData(4, 4, true, false);
        boolean installDecoration = true;
        if (installDecoration) {
            data.horizontalIndent = 6;
        }
        this.fInputField.setLayoutData((Object)data);
        this.fInputField.setFont(terminal.getFont());
        new ContentAssistCommandAdapter((Control)this.fInputField, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new FieldAssist(), null, null, installDecoration);
        this.fInputField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (!e.doit) {
                    return;
                }
                if (e.character == '\r' || e.character == '\n') {
                    e.doit = false;
                    String line = CommandInputFieldWithHistory.this.fInputField.getText();
                    if (!terminal.pasteString(line + "\r")) {
                        return;
                    }
                    CommandInputFieldWithHistory.this.pushLine(line);
                    this.setCommand("");
                } else if (e.keyCode == 0x1000001 || e.keyCode == 0x1000005) {
                    e.doit = false;
                    this.setCommand(CommandInputFieldWithHistory.this.move(CommandInputFieldWithHistory.this.fInputField.getText(), 1));
                } else if (e.keyCode == 0x1000002 || e.keyCode == 0x1000006) {
                    e.doit = false;
                    this.setCommand(CommandInputFieldWithHistory.this.move(CommandInputFieldWithHistory.this.fInputField.getText(), -1));
                } else if (e.keyCode == 27) {
                    e.doit = false;
                    this.setCommand(CommandInputFieldWithHistory.this.escape());
                }
            }

            private void setCommand(String line) {
                if (line == null) {
                    return;
                }
                CommandInputFieldWithHistory.this.fInputField.setText(line);
                CommandInputFieldWithHistory.this.fInputField.setSelection(CommandInputFieldWithHistory.this.fInputField.getCharCount());
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    @Override
    public void setFont(Font font) {
        this.fInputField.setFont(font);
        this.fInputField.getParent().layout(true);
    }

    @Override
    public void dispose() {
        this.fSash.dispose();
        this.fSash = null;
        this.fPanel.dispose();
        this.fPanel = null;
        this.fInputField.dispose();
        this.fInputField = null;
    }

    private class FieldAssist
    implements IContentProposalProvider {
        private FieldAssist() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            String prefix = contents.substring(0, position);
            ArrayList<Proposal> result = new ArrayList<Proposal>();
            HashSet<String> seen = new HashSet<String>();
            for (String history : CommandInputFieldWithHistory.this.fHistory) {
                if (!history.startsWith(prefix) || seen.contains(history)) continue;
                String content = history.substring(prefix.length());
                result.add(new Proposal(content, history));
                seen.add(history);
            }
            return result.toArray(new IContentProposal[result.size()]);
        }
    }

    private static class Proposal
    implements IContentProposal {
        private final String fContent;
        private final String fLabel;

        Proposal(String content, String label) {
            this.fContent = content;
            this.fLabel = label;
        }

        public String getContent() {
            return this.fContent;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getDescription() {
            return null;
        }

        public int getCursorPosition() {
            return this.fContent.length();
        }
    }
}

