/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.javascript.jscomp.LoggerErrorManager;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.DepsFileParser;
import com.google.javascript.jscomp.deps.ServiceException;
import com.google.javascript.jscomp.deps.SimpleDependencyInfo;
import com.google.javascript.jscomp.deps.SourceFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class DependencyFile
implements SourceFile {
    private final Map<String, DependencyInfo> dependencies = new HashMap<String, DependencyInfo>();
    private final SourceFile delegate;
    private static Logger logger = Logger.getLogger(DependencyFile.class.getName());

    public DependencyFile(SourceFile delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getName() throws ServiceException {
        return this.delegate.getName();
    }

    @Override
    public String getContent() throws ServiceException {
        return this.delegate.getContent();
    }

    @Override
    public boolean wasModified() throws ServiceException {
        return this.delegate.wasModified();
    }

    public void ensureUpToDate() throws ServiceException {
        if (this.dependencies.isEmpty() || this.wasModified()) {
            this.loadGraph();
        }
    }

    public DependencyInfo getDependencyInfo(String symbol) {
        return this.dependencies.get(symbol);
    }

    private void loadGraph() throws ServiceException {
        this.dependencies.clear();
        logger.info("Loading dependency graph");
        LoggerErrorManager errorManager = new LoggerErrorManager(logger);
        DepsFileParser parser = new DepsFileParser(errorManager);
        List<DependencyInfo> depInfos = parser.parseFile(this.getName(), this.getContent());
        if (!parser.didParseSucceed()) {
            throw new ServiceException("Problem parsing " + this.getName() + ". See logs for details.");
        }
        for (DependencyInfo depInfo : depInfos) {
            for (String provide : depInfo.getProvides()) {
                DependencyInfo existing = this.dependencies.get(provide);
                if (existing != null && !existing.equals(depInfo)) {
                    throw new ServiceException("Duplicate provide of " + provide + ". Was provided by " + existing.getPathRelativeToClosureBase() + " and " + depInfo.getPathRelativeToClosureBase());
                }
                this.dependencies.put(provide, depInfo);
            }
        }
        ArrayList<String> provides = new ArrayList<String>();
        provides.add("goog");
        this.dependencies.put("goog", new SimpleDependencyInfo("base.js", "base.js", provides, Collections.emptyList(), false));
        errorManager.generateReport();
        logger.info("Dependencies loaded");
    }
}

