/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource.undostates;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.AbstractResourceUndoState;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.FileUndoState;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.FolderUndoState;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.ProjectUndoState;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.ResourceUndoState;

public abstract class ContainerUndoState
extends AbstractResourceUndoState {
    protected String name;
    protected URI location;
    private String defaultCharSet;
    private List<AbstractResourceUndoState> members;

    public static ContainerUndoState fromContainer(IContainer container) {
        IPath fullPath = container.getFullPath();
        ContainerUndoState firstCreatedParent = null;
        ContainerUndoState currentContainerDescription = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer currentContainer = (IContainer)root.findMember(fullPath);
        if (currentContainer != null) {
            return (ContainerUndoState)ResourceUndoState.fromResource((IResource)container);
        }
        currentContainer = root;
        int i = 0;
        while (i < fullPath.segmentCount()) {
            String currentSegment = fullPath.segment(i);
            IResource resource = currentContainer.findMember(currentSegment);
            if (resource != null) {
                currentContainer = (IContainer)resource;
            } else if (i == 0) {
                currentContainerDescription = firstCreatedParent = new ProjectUndoState(root.getProject(currentSegment));
            } else {
                IFolder folderHandle = currentContainer.getFolder((IPath)new Path(currentSegment));
                FolderUndoState currentFolder = new FolderUndoState(folderHandle);
                currentContainer = folderHandle;
                if (currentContainerDescription != null) {
                    currentContainerDescription.addMember(currentFolder);
                }
                currentContainerDescription = currentFolder;
                if (firstCreatedParent == null) {
                    firstCreatedParent = currentFolder;
                }
            }
            ++i;
        }
        return firstCreatedParent;
    }

    public ContainerUndoState() {
    }

    public ContainerUndoState(IContainer container) {
        super((IResource)container);
        this.name = container.getName();
        if (container.isLinked()) {
            this.location = container.getLocationURI();
        }
        try {
            if (container.isAccessible()) {
                this.defaultCharSet = container.getDefaultCharset(false);
                IResource[] resourceMembers = container.members();
                this.members = new ArrayList<AbstractResourceUndoState>(resourceMembers.length);
                IResource[] iResourceArray = resourceMembers;
                int n = resourceMembers.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resourceMember = iResourceArray[n2];
                    if (this.localTimeStamp != -1L || resourceMember.isLinked()) {
                        this.members.add((AbstractResourceUndoState)ResourceUndoState.fromResource(resourceMember));
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void createChildResources(IContainer parentHandle, IProgressMonitor monitor) throws CoreException {
        if (this.members != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.members.size());
            for (AbstractResourceUndoState member : this.members) {
                member.parent = parentHandle;
                member.createResource((IProgressMonitor)subMonitor.newChild(1));
            }
        }
    }

    @Override
    public void recordStateFromHistory(IResource resource, IProgressMonitor monitor) throws CoreException {
        if (this.members != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringCoreMessages.FolderDescription_SavingUndoInfoProgress, (int)this.members.size());
            for (AbstractResourceUndoState member : this.members) {
                IPath path;
                if (member instanceof FileUndoState) {
                    path = resource.getFullPath().append(((FileUndoState)member).name);
                    IFile fileHandle = resource.getWorkspace().getRoot().getFile(path);
                    member.recordStateFromHistory((IResource)fileHandle, (IProgressMonitor)subMonitor.newChild(1));
                    continue;
                }
                if (!(member instanceof FolderUndoState)) continue;
                path = resource.getFullPath().append(((FolderUndoState)member).name);
                IFolder folderHandle = resource.getWorkspace().getRoot().getFolder(path);
                member.recordStateFromHistory((IResource)folderHandle, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ContainerUndoState getFirstLeafFolder() {
        if (this.members == null || this.members.isEmpty()) {
            return this;
        }
        for (AbstractResourceUndoState member : this.members) {
            if (!(member instanceof ContainerUndoState)) continue;
            return ((ContainerUndoState)member).getFirstLeafFolder();
        }
        return this;
    }

    public void addMember(AbstractResourceUndoState member) {
        if (this.members == null) {
            this.members = new ArrayList<AbstractResourceUndoState>();
        }
        this.members.add(member);
    }

    @Override
    protected void restoreResourceAttributes(IResource resource) throws CoreException {
        super.restoreResourceAttributes(resource);
        Assert.isLegal((boolean)(resource instanceof IContainer));
        IContainer container = (IContainer)resource;
        if (this.defaultCharSet != null) {
            container.setDefaultCharset(this.defaultCharSet, null);
        }
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    @Override
    public boolean verifyExistence(boolean checkMembers) {
        boolean existence = super.verifyExistence(checkMembers);
        if (existence) {
            if (checkMembers && this.members != null) {
                for (AbstractResourceUndoState member : this.members) {
                    if (member.verifyExistence(checkMembers)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

