/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.markup.token;

import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class EntityWrappingReplacementToken
extends PatternBasedElement {
    private final String delimiter;
    private final String leftEntity;
    private final String rightEntity;

    public EntityWrappingReplacementToken(String delimiter, String leftEntity, String rightEntity) {
        this.delimiter = delimiter;
        this.leftEntity = leftEntity;
        this.rightEntity = rightEntity;
        if (delimiter.length() != 1) {
            throw new IllegalArgumentException(delimiter);
        }
    }

    @Override
    public String getPattern(int groupOffset) {
        Object quoted = Character.isLetterOrDigit(this.delimiter.charAt(0)) ? this.delimiter : "\\" + this.delimiter;
        return "(?:(?:(?<=\\W)|^)" + (String)quoted + "([^" + (String)quoted + "]+)" + (String)quoted + "(?=\\W))";
    }

    @Override
    protected int getPatternGroupCount() {
        return 1;
    }

    @Override
    protected PatternBasedElementProcessor newProcessor() {
        return new EntityWrappingReplacementTokenProcessor(this.leftEntity, this.rightEntity);
    }

    private static class EntityWrappingReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private final String leftEntity;
        private final String rightEntity;

        public EntityWrappingReplacementTokenProcessor(String leftEntity, String rightEntity) {
            this.leftEntity = leftEntity;
            this.rightEntity = rightEntity;
        }

        @Override
        public void emit() {
            String content = this.group(1);
            this.builder.entityReference(this.leftEntity);
            this.builder.characters(content);
            this.builder.entityReference(this.rightEntity);
        }
    }
}

