/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.internal.IRepositoryCommit;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.internal.GitLabels;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.DiffDocument;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class DiffEditorInput
implements IEditorInput {
    private IDocument document;
    private String title;
    private String tooltip;
    @NonNull
    private final IRepositoryCommit tip;
    private final IRepositoryCommit base;

    public DiffEditorInput(@NonNull IRepositoryCommit commit) {
        this(commit, null, null, null);
    }

    public DiffEditorInput(@NonNull IRepositoryCommit tip, IRepositoryCommit base) {
        this(tip, base, null, null);
    }

    public DiffEditorInput(@NonNull IRepositoryCommit tip, IRepositoryCommit base, DiffDocument diff) {
        this(tip, base, diff, null);
    }

    public DiffEditorInput(@NonNull IRepositoryCommit tip, IRepositoryCommit base, DiffDocument diff, String title) {
        Assert.isLegal((base == null || tip.getRepository().getDirectory().equals(base.getRepository().getDirectory()) ? 1 : 0) != 0);
        this.tip = tip;
        this.base = base;
        this.document = diff;
        this.title = title;
    }

    @NonNull
    public IRepositoryCommit getTip() {
        return this.tip;
    }

    public IRepositoryCommit getBase() {
        return this.base;
    }

    public void setDocument(IDocument diff) {
        this.document = diff;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public String getName() {
        if (this.title == null) {
            this.title = this.base == null ? MessageFormat.format(UIText.DiffEditorInput_Title1, Utils.getShortObjectId((ObjectId)this.tip.getObjectId()), GitLabels.getPlainShortLabel(this.tip.getRepository())) : MessageFormat.format(UIText.DiffEditorInput_Title2, Utils.getShortObjectId((ObjectId)this.base.getObjectId()), Utils.getShortObjectId((ObjectId)this.tip.getObjectId()), GitLabels.getPlainShortLabel(this.tip.getRepository()));
        }
        return this.title;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DiffEditorInput)) {
            return false;
        }
        DiffEditorInput other = (DiffEditorInput)obj;
        if (!Objects.equals(this.tip.getRepository().getDirectory(), other.tip.getRepository().getDirectory())) {
            return false;
        }
        if (!Objects.equals(this.tip.getObjectId(), other.tip.getObjectId())) {
            return false;
        }
        return !(this.base == null ? other.base != null : other.base == null || !Objects.equals(this.base.getObjectId(), other.base.getObjectId()));
    }

    public int hashCode() {
        return Objects.hash(this.tip.getObjectId(), this.tip.getRepository().getDirectory(), this.base == null ? null : this.base.getObjectId());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IRepositoryCommit.class) {
            return adapter.cast(this.tip);
        }
        if (adapter == RevCommit.class) {
            return adapter.cast(this.tip.getRevCommit());
        }
        if (adapter == Repository.class) {
            return adapter.cast(this.tip.getRepository());
        }
        return null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return UIIcons.CHANGESET;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        if (this.tooltip == null) {
            this.tooltip = this.base == null ? MessageFormat.format(UIText.DiffEditorInput_Tooltip1, Utils.getShortObjectId((ObjectId)this.tip.getObjectId()), GitLabels.getPlainShortLabel(this.tip.getRepository())) : MessageFormat.format(UIText.DiffEditorInput_Tooltip2, Utils.getShortObjectId((ObjectId)this.base.getObjectId()), Utils.getShortObjectId((ObjectId)this.tip.getObjectId()), GitLabels.getPlainShortLabel(this.tip.getRepository()));
        }
        return this.tooltip;
    }
}

