/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsole;
import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsoleManager;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbBasicCliConsole;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbFullCliConsole;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.IGDBDebuggerConsole;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;

public class GdbCliConsoleManager
implements ILaunchesListener2 {
    public void startup() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void shutdown() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    public void launchesAdded(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.handleConsoleForLaunch(launch);
            ++n2;
        }
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.removeConsole(launch);
            ++n2;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.renameConsole(launch);
            this.stopConsole(launch);
            ++n2;
        }
    }

    protected void handleConsoleForLaunch(ILaunch launch) {
        if (launch instanceof GdbLaunch) {
            new GdbConsoleCreator((GdbLaunch)launch).init();
        }
    }

    protected void removeConsole(ILaunch launch) {
        IDebuggerConsole console = this.getConsole(launch);
        if (console != null) {
            this.removeConsole(console);
        }
    }

    protected void stopConsole(ILaunch launch) {
        IDebuggerConsole console = this.getConsole(launch);
        if (console != null) {
            console.stop();
        }
    }

    private void renameConsole(ILaunch launch) {
        IDebuggerConsole console = this.getConsole(launch);
        if (console != null) {
            console.resetName();
        }
    }

    private IDebuggerConsole getConsole(ILaunch launch) {
        IDebuggerConsoleManager manager = CDebugUIPlugin.getDebuggerConsoleManager();
        IDebuggerConsole[] iDebuggerConsoleArray = manager.getConsoles();
        int n = iDebuggerConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebuggerConsole console = iDebuggerConsoleArray[n2];
            if (console.getLaunch().equals(launch)) {
                return console;
            }
            ++n2;
        }
        return null;
    }

    private void addConsole(IDebuggerConsole console) {
        this.getDebuggerConsoleManager().addConsole(console);
    }

    private void removeConsole(IDebuggerConsole console) {
        this.getDebuggerConsoleManager().removeConsole(console);
    }

    private IDebuggerConsoleManager getDebuggerConsoleManager() {
        return CDebugUIPlugin.getDebuggerConsoleManager();
    }

    private class GdbConsoleCreator {
        private GdbLaunch fLaunch;
        private DsfSession fSession;

        public GdbConsoleCreator(GdbLaunch launch) {
            this.fLaunch = launch;
            this.fSession = launch.getSession();
        }

        public void init() {
            try {
                this.fSession.getExecutor().submit((Runnable)new DsfRunnable(){

                    public void run() {
                        DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), GdbConsoleCreator.this.fSession.getId());
                        ICommandControlService control = (ICommandControlService)tracker.getService(ICommandControlService.class);
                        IMIBackend backend = (IMIBackend)tracker.getService(IMIBackend.class);
                        tracker.dispose();
                        if (backend != null && control != null) {
                            GdbConsoleCreator.this.verifyAndCreateCliConsole();
                        } else {
                            new GdbServiceStartedListener(GdbConsoleCreator.this, GdbConsoleCreator.this.fSession);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        @ConfinedToDsfExecutor(value="fSession.getExecutor()")
        private void verifyAndCreateCliConsole() {
            IGDBDebuggerConsole console;
            String gdbVersion;
            block7: {
                try {
                    gdbVersion = this.fLaunch.getGDBVersion();
                }
                catch (CoreException e) {
                    gdbVersion = "???";
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)"Should not happen since the gdb version is cached");
                }
            }
            String consoleTitle = this.fLaunch.getGDBPath().toOSString().trim() + " (" + gdbVersion + ")";
            DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), this.fSession.getId());
            IGDBControl control = (IGDBControl)tracker.getService(IGDBControl.class);
            IGDBBackend backend = (IGDBBackend)tracker.getService(IGDBBackend.class);
            tracker.dispose();
            if (backend != null && backend.isFullGdbConsoleSupported()) {
                console = new GdbFullCliConsole((ILaunch)this.fLaunch, consoleTitle, backend.getProcess(), backend.getProcessPty());
            } else if (control != null) {
                console = new GdbBasicCliConsole((ILaunch)this.fLaunch, consoleTitle, control.getGDBBackendProcess());
            } else {
                assert (false);
                return;
            }
            GdbCliConsoleManager.this.addConsole(console);
        }
    }

    public class GdbServiceStartedListener {
        private DsfSession fSession;
        private GdbConsoleCreator fCreator;

        public GdbServiceStartedListener(GdbConsoleCreator creator, DsfSession session) {
            this.fCreator = creator;
            this.fSession = session;
            this.fSession.addServiceEventListener((Object)this, null);
        }

        @DsfServiceEventHandler
        public final void eventDispatched(ICommandControlService.ICommandControlInitializedDMEvent event) {
            this.fCreator.verifyAndCreateCliConsole();
            this.fSession.removeServiceEventListener((Object)this);
        }
    }
}

