/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.io.IOException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;

class CacheCredentialsAuthenticationStrategy
implements HttpResponseInterceptor {
    public static final String CREDENTIALS_CACHE_ATTRIBUTE = CacheCredentialsAuthenticationStrategy.class.getName() + ".credentialsCache";
    public static final String CURRENT_CREDENTIALS = CacheCredentialsAuthenticationStrategy.class.getName() + ".currentCredentials";

    CacheCredentialsAuthenticationStrategy() {
    }

    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRoute route = (HttpRoute)clientContext.getHttpRoute();
        HttpHost authhost = route.getProxyHost();
        AuthScheme authScheme = clientContext.getAuthExchange(authhost).getAuthScheme();
        if (response.getCode() == 401 || response.getCode() == 407) {
            this.uncacheCredentials(authhost, authScheme, clientContext);
        } else if (authScheme != null && authScheme.isChallengeComplete()) {
            this.cacheCredentials(authhost, authScheme, clientContext);
        }
    }

    private void uncacheCredentials(HttpHost authhost, AuthScheme authScheme, HttpClientContext context) {
        CredentialsStore credentialsCache = CacheCredentialsAuthenticationStrategy.getCredentialsCache((HttpContext)context);
        if (credentialsCache != null) {
            AuthScope scope = CacheCredentialsAuthenticationStrategy.createAuthScope(authhost, authScheme);
            credentialsCache.setCredentials(scope, null);
        }
    }

    private void cacheCredentials(HttpHost authhost, AuthScheme authScheme, HttpClientContext context) {
        CredentialsStore credentialsCache;
        AuthScope scope = CacheCredentialsAuthenticationStrategy.createAuthScope(authhost, authScheme);
        Credentials credentials = (Credentials)context.getAttribute(CURRENT_CREDENTIALS, Credentials.class);
        if (credentials != null && (credentialsCache = CacheCredentialsAuthenticationStrategy.getCredentialsCache((HttpContext)context)) != null) {
            credentialsCache.setCredentials(scope, credentials);
        }
    }

    private static CredentialsStore getCredentialsCache(HttpContext context) {
        CredentialsStore credentialsCache = null;
        Object value = context.getAttribute(CREDENTIALS_CACHE_ATTRIBUTE);
        if (value instanceof CredentialsStore) {
            credentialsCache = (CredentialsStore)value;
        }
        return credentialsCache;
    }

    private static AuthScope createAuthScope(HttpHost targetHost, AuthScheme scheme) {
        String schemeName = null;
        String realm = null;
        if (scheme != null) {
            schemeName = scheme.getName();
            realm = scheme.getRealm();
        }
        return new AuthScope(targetHost, realm, schemeName);
    }
}

