/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.tcl.ast.ISubstitution;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.definitions.Argument;
import org.eclipse.dltk.tcl.definitions.ArgumentType;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.definitions.ComplexArgument;
import org.eclipse.dltk.tcl.definitions.Constant;
import org.eclipse.dltk.tcl.definitions.Group;
import org.eclipse.dltk.tcl.definitions.Switch;
import org.eclipse.dltk.tcl.definitions.TypedArgument;
import org.eclipse.dltk.tcl.parser.ISubstitutionManager;
import org.eclipse.dltk.tcl.parser.ITclErrorConstants;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.Messages;
import org.eclipse.dltk.tcl.parser.TclErrorCollector;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionUtils;
import org.eclipse.dltk.tcl.parser.definitions.SynopsisBuilder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclArgumentMatcher {
    public static final String SHORT_ARG = "short:";
    public static final String SYNOPSIS_ARG = "synopsis:";
    private List<Integer> codePositions;
    private TclErrorCollector errors;
    private TclCommand command;
    private List<ComplexArgumentResult> complexArguments;
    private ISubstitutionManager substitutionManager;
    private HashMap<Argument, int[]> mappings;
    private SynopsisBuilder synopsisBuilder = new SynopsisBuilder(false);

    public TclArgumentMatcher(TclCommand command, Map<String, Boolean> map, ISubstitutionManager substitutionManager) {
        this.command = command;
        this.substitutionManager = substitutionManager;
    }

    public boolean match(Command definition) {
        this.codePositions = new ArrayList<Integer>();
        this.errors = new TclErrorCollector();
        this.complexArguments = new ArrayList<ComplexArgumentResult>();
        this.mappings = new HashMap();
        EList<Argument> definitionArguments = definition.getArguments();
        EList<TclArgument> arguments = this.command.getArguments();
        int argSize = arguments.size();
        if (argSize == 0 && definitionArguments.size() == 0) {
            return true;
        }
        MatchResult result = this.matchArgument((List<TclArgument>)arguments, 0, (List<Argument>)definitionArguments, 0);
        this.errors.addAll(result.getErrors());
        if (result.isMatched()) {
            this.codePositions.addAll(result.getBlockArguments());
            this.complexArguments.addAll(result.getComplexArguments());
            this.mappings.putAll(result.getMapping());
            if (result.getArgumentsUsed() == argSize) {
                return true;
            }
            if (result.getArgumentsUsed() < argSize) {
                this.reportExtraArguments((List<TclArgument>)arguments, result.getArgumentsUsed(), this.errors);
                return true;
            }
        }
        if (this.errors.getCount() == 0) {
            this.reportInvalidArgumentCount(this.command.getStart(), this.command.getEnd(), argSize, this.errors, definition);
        }
        return false;
    }

    private SubstitutedArgumentValue getSubstitutedArgumentValue(TclArgument arg) {
        if (arg instanceof StringArgument) {
            String value = ((StringArgument)arg).getValue();
            if (value.startsWith("{") && value.endsWith("}")) {
                SubstitutedArgumentValue val = new SubstitutedArgumentValue();
                val.value = value.substring(1, value.length() - 1);
                val.offset = 1;
                return val;
            }
            if (value.startsWith("\"") && value.endsWith("\"")) {
                SubstitutedArgumentValue val = new SubstitutedArgumentValue();
                val.value = value.substring(1, value.length() - 1);
                val.offset = 1;
                return val;
            }
            SubstitutedArgumentValue val = new SubstitutedArgumentValue();
            val.value = value;
            val.offset = 0;
            return val;
        }
        if (arg instanceof ISubstitution && this.substitutionManager != null) {
            SubstitutedArgumentValue val = new SubstitutedArgumentValue();
            val.value = this.substitutionManager.substitute((ISubstitution)((Object)arg));
            val.offset = 0;
            return val;
        }
        SubstitutedArgumentValue val = new SubstitutedArgumentValue();
        val.value = null;
        val.offset = 0;
        return val;
    }

    public void reportErrors(ITclErrorReporter reporter) {
        if (this.errors != null && reporter != null) {
            this.errors.reportAll(reporter);
        }
    }

    public int[] getBlockArguments() {
        return TclArgumentMatcher.getArrayFromList(this.codePositions);
    }

    private static int[] getArrayFromList(List<Integer> list) {
        int lsize = list.size();
        int[] positions = new int[lsize];
        int i = 0;
        while (i < lsize) {
            positions[i] = list.get(i);
            ++i;
        }
        return positions;
    }

    public ComplexArgumentResult[] getComplexArguments() {
        return this.complexArguments.toArray(new ComplexArgumentResult[this.complexArguments.size()]);
    }

    private MatchResult matchArgument(List<TclArgument> arguments, int pos, List<Argument> definitionArguments, int defPos) {
        List<MatchResult> results = this.matchArgumentList(arguments, pos, definitionArguments, defPos);
        MatchResult result = null;
        for (MatchResult sr : results) {
            int srPriority;
            if (result == null) {
                result = sr;
                continue;
            }
            int rpriority = result.getPriority();
            if (rpriority > (srPriority = sr.getPriority())) continue;
            if (rpriority < srPriority) {
                result = sr;
                continue;
            }
            if (!result.isMatched() && sr.isMatched()) {
                result = sr;
                continue;
            }
            TclErrorCollector rErrors = result.getErrors();
            TclErrorCollector srErrors = sr.getErrors();
            int rArgsUsed = result.getArgumentsUsed();
            if (rErrors.getCount() > srErrors.getCount() && rArgsUsed >= sr.getArgumentsUsed()) {
                result = sr;
                continue;
            }
            if (rErrors.getCount() < srErrors.getCount() || rArgsUsed >= sr.getArgumentsUsed()) continue;
            result = sr;
        }
        return result;
    }

    private List<MatchResult> matchArgumentList(List<TclArgument> arguments, int pos, List<Argument> definition, int defPos) {
        ArrayList<MatchResult> results = new ArrayList<MatchResult>();
        if (definition.size() == defPos) {
            MatchResult result = new MatchResult();
            result.setMatched(true);
            result.setMatchWithErrors(false);
            result.setArgumentsUsed(0);
            results.add(result);
            return results;
        }
        Argument definitionArg = definition.get(defPos);
        List<MatchResult> list = this.matchDefinition(arguments, pos, definitionArg);
        int lsize = list.size();
        if ((lsize == 0 || lsize == 1 && !list.get(0).isMatched() && !list.get(0).isImplicit()) && arguments.size() > pos + 1) {
            ArrayList<TclArgument> extraArgs = new ArrayList<TclArgument>();
            extraArgs.add(arguments.get(pos));
            List<MatchResult> srl = this.matchArgumentList(arguments, pos + 1, definition, defPos);
            for (MatchResult matchResult : srl) {
                if (!matchResult.isMatched()) continue;
                this.reportExtraArguments(extraArgs, 0, matchResult.getErrors());
                matchResult.setArgumentsUsed(matchResult.getArgumentsUsed() + 1);
                list.add(matchResult);
            }
        }
        TclErrorCollector collector = new TclErrorCollector();
        for (MatchResult r : list) {
            if (r.isMatched() || r.isImplicit()) {
                MatchResult sr2;
                List<MatchResult> srl = this.matchArgumentList(arguments, pos + r.getArgumentsUsed(), definition, defPos + 1);
                boolean matched = false;
                for (MatchResult sr2 : srl) {
                    if (!sr2.isMatched()) continue;
                    matched = true;
                    sr2.setSummaryPriorityOf(r, sr2);
                    sr2.setMatchWithErrors(sr2.isMatchWithErrors() || r.isMatchWithErrors());
                    sr2.setArgumentsUsed(sr2.getArgumentsUsed() + r.getArgumentsUsed());
                    sr2.getErrors().addAll(r.getErrors());
                    sr2.getBlockArguments().addAll(r.getBlockArguments());
                    sr2.getMapping().putAll(r.getMapping());
                    sr2.getComplexArguments().addAll(r.getComplexArguments());
                    results.add(sr2);
                }
                if (matched || srl.size() != 1) continue;
                for (MatchResult sr2 : srl) {
                    collector.addAll(sr2.getErrors());
                }
                sr2 = srl.get(0);
                if (results.size() != 0) continue;
                MatchResult result = new MatchResult();
                result.setMatched(false);
                result.setSummaryPriorityOf(r, sr2);
                result.setMatchWithErrors(true);
                result.getErrors().addAll(sr2.getErrors());
                result.setArgumentsUsed(r.getArgumentsUsed() + sr2.getArgumentsUsed());
                results.add(result);
                continue;
            }
            collector.addAll(r.getErrors());
        }
        if (results.size() == 0) {
            int last = arguments.size() - pos;
            MatchResult matchResult = new MatchResult();
            matchResult.setMatched(false);
            matchResult.setArgumentsUsed(last > 0 ? last : 0);
            matchResult.setMatchWithErrors(last <= 0);
            matchResult.getErrors().addAll(collector);
            results.add(matchResult);
        }
        return results;
    }

    private List<MatchResult> matchDefinition(List<TclArgument> arguments, int pos, Argument definition) {
        ArrayList<MatchResult> results = new ArrayList<MatchResult>();
        if (definition instanceof Constant) {
            this.matchConstant(arguments, pos, definition, results);
            for (MatchResult result : results) {
                if (!result.isMatched() || result.getArgumentsUsed() <= 0 || !(arguments.get(pos) instanceof StringArgument)) continue;
                result.incrPriority();
                result.incrPriority();
            }
        } else if (definition instanceof TypedArgument) {
            this.matchTypedArgument(arguments, pos, definition, results);
        } else if (definition instanceof Group) {
            this.matchGroupArgument(arguments, pos, definition, results);
        } else if (definition instanceof Switch) {
            this.matchSwitchArgument(arguments, pos, definition, results);
        } else if (definition instanceof ComplexArgument) {
            this.matchComplexArgument(arguments, pos, definition, results);
        }
        return results;
    }

    private void matchComplexArgument(List<TclArgument> arguments, int pos, Argument definition, List<MatchResult> results) {
        this.matchSinglePositionArgument(results, arguments, pos, definition, new ISinglePositionRule(){

            @Override
            public boolean check(TclArgument argument, Argument definition, List<Integer> scriptPositions, int position, TclErrorCollector collector, List<ComplexArgumentResult> results) {
                EList<Argument> definitionArguments;
                ComplexArgument complexArgument = (ComplexArgument)definition;
                SubstitutedArgumentValue substring = TclArgumentMatcher.this.getSubstitutedArgumentValue(argument);
                if (substring.value == null) {
                    return true;
                }
                List<TclArgument> subArguments = TclParserUtils.parseCommandArguments(argument.getStart() + substring.offset, substring.value, null);
                MatchResult res = TclArgumentMatcher.this.matchArgument(subArguments, 0, definitionArguments = complexArgument.getArguments(), 0);
                if (res.isMatched()) {
                    ComplexArgumentResult cResult = new ComplexArgumentResult(position, subArguments, res.getBlockArguments());
                    cResult.getComplexArguments().addAll(res.getComplexArguments());
                    collector.reportAll(res.getErrors());
                    cResult.setDefinition(complexArgument);
                    results.add(cResult);
                    if (res.getArgumentsUsed() < subArguments.size()) {
                        TclArgumentMatcher.this.reportExtraArguments(subArguments, res.getArgumentsUsed(), collector);
                    }
                    return true;
                }
                return false;
            }
        }, false);
    }

    private void matchExpression(List<TclArgument> arguments, int pos, Argument definition, List<MatchResult> results) {
        this.matchSinglePositionArgument(results, arguments, pos, definition, new ISinglePositionRule(){

            @Override
            public boolean check(TclArgument argument, Argument definition, List<Integer> scriptPositions, int position, TclErrorCollector collector, List<ComplexArgumentResult> results) {
                SubstitutedArgumentValue substring = TclArgumentMatcher.this.getSubstitutedArgumentValue(argument);
                if (substring.value == null) {
                    return true;
                }
                ArrayList<Integer> blockArguments = new ArrayList<Integer>();
                List<TclArgument> subArguments = TclParserUtils.parseCommandArguments(argument.getStart() + substring.offset, substring.value, blockArguments);
                ComplexArgumentResult cResult = new ComplexArgumentResult(position, subArguments, blockArguments);
                results.add(cResult);
                return true;
            }
        }, false);
    }

    private void matchSwitchArgument(List<TclArgument> arguments, int pos, Argument definition, List<MatchResult> results) {
        MatchResult r;
        Switch switchDef = (Switch)definition;
        int lowerBound = switchDef.getLowerBound();
        int upperBound = switchDef.getUpperBound();
        if (upperBound == -1) {
            upperBound = Integer.MAX_VALUE;
        }
        ArrayList<MatchResult> ress = new ArrayList<MatchResult>();
        HashMap<MatchResult, Integer> counts = new HashMap<MatchResult, Integer>();
        this.matchSwitch(arguments, pos, switchDef, ress, counts, 0, upperBound);
        int ressSize = ress.size();
        int i = 0;
        while (i < ressSize) {
            r = (MatchResult)ress.get(i);
            Integer count = (Integer)counts.get(r);
            if (count != null && count < lowerBound) {
                r.setMatchWithErrors(true);
                this.reportMissingArgument(definition, r, this.command.getStart(), this.command.getEnd());
                results.add(r);
            }
            if (count != null && count >= lowerBound && count <= upperBound) {
                results.add(r);
            }
            ++i;
        }
        int argSize = arguments.size();
        if (ressSize == 0 && argSize > pos && DefinitionUtils.isMode(switchDef) && arguments.get(pos) instanceof ISubstitution) {
            r = new MatchResult();
            r.setArgumentsUsed(1);
            r.setMatched(true);
            r.setMatchWithErrors(false);
            results.add(r);
        }
        if (ressSize == 0 && lowerBound > 0) {
            r = new MatchResult();
            r.setArgumentsUsed(0);
            r.setMatched(false);
            r.setMatchWithErrors(false);
            TclArgument a = null;
            if (argSize > pos) {
                a = arguments.get(pos);
            }
            this.reportMissingSwitch(switchDef, r, a);
            results.add(r);
        } else if (lowerBound == 0) {
            r = new MatchResult();
            r.setArgumentsUsed(0);
            r.setMatched(true);
            r.setMatchWithErrors(false);
            results.add(r);
        }
    }

    private void matchSwitch(List<TclArgument> arguments, int pos, Switch sw, List<MatchResult> ress, Map<MatchResult, Integer> counts, int count, int upperBound) {
        TclErrorCollector errors = new TclErrorCollector();
        if (pos >= arguments.size()) {
            return;
        }
        ArrayList<MatchResult> list = new ArrayList<MatchResult>();
        Map<Group, Argument> fitGroupMap = this.getFitGroupMap(arguments, pos, sw);
        HashMap<String, ArrayList<Group>> constFitGroupMap = new HashMap<String, ArrayList<Group>>();
        for (Group group : fitGroupMap.keySet()) {
            Argument selector = fitGroupMap.get(group);
            if (!(selector instanceof Constant)) continue;
            ArrayList<Group> groups = (ArrayList<Group>)constFitGroupMap.get(selector);
            if (groups == null) {
                groups = new ArrayList<Group>();
            }
            groups.add(group);
            constFitGroupMap.put(selector.getName(), groups);
            fitGroupMap.remove(fitGroupMap.get(group));
        }
        if (constFitGroupMap.size() == 1) {
            for (String string : constFitGroupMap.keySet()) {
                ((StringArgument)arguments.get(pos)).setValue(string);
                for (Group group : (List)constFitGroupMap.get(string)) {
                    this.matchGroupArgument(arguments, pos, group, list);
                }
            }
        } else {
            for (Group group : fitGroupMap.keySet()) {
                this.matchGroupArgument(arguments, pos, group, list);
            }
            if (list.size() == 1) {
                MatchResult r = (MatchResult)list.get(0);
                if (sw.getLowerBound() > 0) {
                    r.incrPriority();
                }
            }
        }
        int lSize = list.size();
        int j = 0;
        while (j < lSize) {
            MatchResult r = (MatchResult)list.get(j);
            if (r.isMatched() || r.isImplicit()) {
                ArrayList<MatchResult> ress2 = new ArrayList<MatchResult>();
                counts.put(r, count + 1);
                ress.add(r);
                if (count + 1 != upperBound && r.getArgumentsUsed() > 0) {
                    this.matchSwitch(arguments, pos + r.getArgumentsUsed(), sw, ress2, counts, count + 1, upperBound);
                    int k = 0;
                    while (k < ress2.size()) {
                        MatchResult r2 = (MatchResult)ress2.get(k);
                        if (r2.isMatched() && !r2.isMatchWithErrors()) {
                            r2.setArgumentsUsed(r.getArgumentsUsed() + r2.getArgumentsUsed());
                            r2.setSummaryPriorityOf(r, r2);
                            r2.getBlockArguments().addAll(r.getBlockArguments());
                            r2.getErrors().addAll(r.getErrors());
                            r2.getMapping().putAll(r.getMapping());
                            r2.getComplexArguments().addAll(r.getComplexArguments());
                            ress.add(r2);
                        }
                        ++k;
                    }
                }
            } else {
                errors.addAll(r.getErrors());
            }
            ++j;
        }
    }

    private void matchGroupArgument(List<TclArgument> arguments, int pos, Argument definition, List<MatchResult> results) {
        Group group = (Group)definition;
        int lowerBound = group.getLowerBound();
        int upperBound = group.getUpperBound();
        if (upperBound == -1) {
            upperBound = Integer.MAX_VALUE;
        }
        Constant constant = DefinitionUtils.extractGroupPseudoConstant(group);
        Object groupArguments = group.getArguments();
        if (constant != null) {
            ArrayList<Argument> newArgs = new ArrayList<Argument>();
            newArgs.add(constant);
            newArgs.addAll((Collection<Argument>)group.getArguments());
            groupArguments = newArgs;
        }
        ArrayList<MatchResult> ress = new ArrayList<MatchResult>();
        HashMap<MatchResult, Integer> counts = new HashMap<MatchResult, Integer>();
        this.matchGroup(arguments, pos, (List<Argument>)groupArguments, (List<MatchResult>)ress, (Map<MatchResult, Integer>)counts, 0, upperBound);
        int ressSize = ress.size();
        int i = 0;
        while (i < ressSize) {
            MatchResult r = (MatchResult)ress.get(i);
            Integer count = (Integer)counts.get(r);
            if (count != null && count < lowerBound) {
                r.setMatchWithErrors(true);
                this.reportMissingArgument(definition, r, this.command.getStart(), this.command.getEnd());
                results.add(r);
            }
            if (count != null && count >= lowerBound && count <= upperBound) {
                results.add(r);
            }
            ++i;
        }
        if (ressSize == 0 && lowerBound > 0) {
            MatchResult r = new MatchResult();
            r.setArgumentsUsed(0);
            r.setMatched(false);
            r.setMatchWithErrors(false);
            this.reportMissingGroup(group, r);
            results.add(r);
        } else if (lowerBound == 0) {
            MatchResult r = new MatchResult();
            r.setArgumentsUsed(0);
            r.setMatched(true);
            r.setMatchWithErrors(false);
            results.add(r);
        }
    }

    private void matchGroup(List<TclArgument> arguments, int pos, List<Argument> groupArguments, List<MatchResult> ress, Map<MatchResult, Integer> counts, int count, int upperBound) {
        TclErrorCollector errors = new TclErrorCollector();
        if (pos >= arguments.size()) {
            return;
        }
        int i = 0;
        while (i < 1) {
            MatchResult r = this.matchArgument(arguments, pos, groupArguments, 0);
            if (r.isMatched() || r.isImplicit() || r.isMatchWithErrors()) {
                ArrayList<MatchResult> ress2 = new ArrayList<MatchResult>();
                counts.put(r, count + 1);
                ress.add(r);
                if (count + 1 != upperBound && r.getArgumentsUsed() > 0) {
                    this.matchGroup(arguments, pos + r.getArgumentsUsed(), groupArguments, ress2, counts, count + 1, upperBound);
                    int ress2Size = ress2.size();
                    int k = 0;
                    while (k < ress2Size) {
                        MatchResult r2 = (MatchResult)ress2.get(k);
                        if (r2.isMatched()) {
                            r2.setArgumentsUsed(r.getArgumentsUsed() + r2.getArgumentsUsed());
                            r2.setSummaryPriorityOf(r, r2);
                            r2.getBlockArguments().addAll(r.getBlockArguments());
                            r2.getErrors().addAll(r.getErrors());
                            r2.getMapping().putAll(r.getMapping());
                            r2.getComplexArguments().addAll(r.getComplexArguments());
                            ress.add(r2);
                        }
                        ++k;
                    }
                }
            } else {
                errors.addAll(r.getErrors());
            }
            ++i;
        }
    }

    private void matchConstant(List<TclArgument> arguments, int pos, Argument definition, List<MatchResult> results) {
        Constant constDefinition = (Constant)definition;
        final String value = constDefinition.getName();
        this.matchSinglePositionArgument(results, arguments, pos, definition, new ISinglePositionRule(){

            @Override
            public boolean check(TclArgument argument, Argument definition, List<Integer> scriptPositions, int position, TclErrorCollector collector, List<ComplexArgumentResult> complex) {
                SubstitutedArgumentValue argumentValue = TclArgumentMatcher.this.getSubstitutedArgumentValue(argument);
                return value.equals(argumentValue.value);
            }
        }, true);
    }

    private void matchTypedArgument(List<TclArgument> arguments, int pos, Argument definition, List<MatchResult> results) {
        TypedArgument arg = (TypedArgument)definition;
        final ArgumentType type = arg.getType();
        if (4 == type.getValue()) {
            this.matchExpression(arguments, pos, definition, results);
        } else {
            this.matchSinglePositionArgument(results, arguments, pos, definition, new ISinglePositionRule(){

                @Override
                public boolean check(TclArgument argument, Argument definition, List<Integer> scriptPositions, int position, TclErrorCollector collector, List<ComplexArgumentResult> complex) {
                    return TclArgumentMatcher.this.checkType(argument, type, scriptPositions, position, collector);
                }
            }, false);
        }
    }

    private void matchSinglePositionArgument(List<MatchResult> results, List<TclArgument> arguments, int pos, Argument definitionArg, ISinglePositionRule rule, boolean returnMaxMatchedResult) {
        int lowerBound = definitionArg.getLowerBound();
        int upperBound = definitionArg.getUpperBound();
        if (upperBound == -1) {
            upperBound = Integer.MAX_VALUE;
        }
        int count = 0;
        ArrayList<Integer> scriptPositions = new ArrayList<Integer>();
        ArrayList<ComplexArgumentResult> complexArguments = new ArrayList<ComplexArgumentResult>();
        HashMap<Integer, TclErrorCollector> collectors = new HashMap<Integer, TclErrorCollector>();
        int argsSize = arguments.size();
        int i = 0;
        while (i < argsSize - pos) {
            TclErrorCollector collector = new TclErrorCollector();
            TclArgument a = arguments.get(pos + i);
            if (!rule.check(a, definitionArg, scriptPositions, pos + i, collector, complexArguments)) {
                if (i >= lowerBound) break;
                collectors.put(i, collector);
                break;
            }
            collectors.put(i, collector);
            if (++count == upperBound) break;
            ++i;
        }
        if (count < lowerBound) {
            MatchResult r = new MatchResult();
            r.setArgumentsUsed(count);
            r.setMatched(count > 0);
            r.setMatchWithErrors(true);
            int start = this.command.getStart();
            int end = this.command.getEnd();
            if (argsSize > pos) {
                TclArgument arg = arguments.get(pos);
                start = arg.getStart();
                end = arg.getEnd();
            }
            this.reportMissingArgument(definitionArg, r, start, end);
            for (Integer integer : collectors.keySet()) {
                if (integer > count) continue;
                r.getErrors().addAll((TclErrorCollector)collectors.get(integer));
            }
            r.getMapping().put(definitionArg, new int[]{pos, pos + count});
            results.add(r);
        }
        if (count >= lowerBound) {
            int up = count;
            if (up > upperBound) {
                up = upperBound;
            }
            int from = lowerBound;
            if (returnMaxMatchedResult) {
                from = count;
            }
            int i2 = from;
            while (i2 <= up) {
                MatchResult r = new MatchResult();
                r.setArgumentsUsed(i2);
                r.setMatched(true);
                r.setMatchWithErrors(false);
                for (Integer integer : scriptPositions) {
                    if (integer >= pos + i2) continue;
                    r.getBlockArguments().add(integer);
                }
                for (ComplexArgumentResult arg : complexArguments) {
                    if (arg.getArgumentNumber() >= pos + i2) continue;
                    r.getComplexArguments().add(arg);
                }
                for (Integer integer : collectors.keySet()) {
                    if (integer > i2) continue;
                    r.getErrors().addAll((TclErrorCollector)collectors.get(integer));
                }
                r.getMapping().put(definitionArg, new int[]{pos, pos + i2});
                results.add(r);
                ++i2;
            }
        }
    }

    protected boolean checkType(TclArgument argument, ArgumentType type, List<Integer> scriptPositions, int position, TclErrorCollector collector) {
        boolean result = false;
        boolean reported = false;
        SubstitutedArgumentValue arg = this.getSubstitutedArgumentValue(argument);
        String value = arg.value;
        if (value == null) {
            return true;
        }
        switch (type.getValue()) {
            case 5: {
                if (value.startsWith("-")) break;
                scriptPositions.add(position);
                result = true;
                break;
            }
            case 1: {
                try {
                    if (value.startsWith("+")) {
                        value = value.substring(1);
                    }
                    Integer.parseInt(value);
                    result = true;
                }
                catch (NumberFormatException numberFormatException) {
                    result = false;
                }
                break;
            }
            case 3: {
                try {
                    int i = Integer.parseInt(value);
                    boolean bl = result = i >= 0;
                    if (result) break;
                    reported = true;
                    this.reportInvalidArgumentValue(argument, type, collector, Messages.TclArgumentMatcher_Error_Number_is_negative);
                }
                catch (NumberFormatException numberFormatException) {
                    result = false;
                }
                break;
            }
            case 2: {
                int i;
                result = false;
                try {
                    Integer.parseInt(value);
                    result = true;
                }
                catch (NumberFormatException numberFormatException) {}
                if (result) break;
                if (value.startsWith("end")) {
                    String sub = value.substring(3);
                    if (sub.length() == 0) {
                        result = true;
                        break;
                    }
                    char c = sub.charAt(0);
                    if (c != '+' && c != '-') break;
                    String sub2 = sub.substring(1);
                    try {
                        int i2 = Integer.parseInt(sub2);
                        result = i2 >= 0;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                int pos = value.indexOf(43);
                if (pos == -1) {
                    pos = value.indexOf(45);
                }
                if (pos == -1) break;
                String p1 = value.substring(0, pos);
                String p2 = value.substring(pos + 1);
                try {
                    i = Integer.parseInt(p1);
                    result = i > 0;
                }
                catch (NumberFormatException numberFormatException) {
                    result = false;
                }
                if (!result) break;
                try {
                    i = Integer.parseInt(p2);
                    result = i >= 0;
                }
                catch (NumberFormatException numberFormatException) {
                    result = false;
                }
                break;
            }
            default: {
                result = true;
            }
        }
        if (!result && !reported) {
            this.reportInvalidArgumentValue(argument, type, collector, null);
        }
        return result;
    }

    private Map<Group, Argument> getFitGroupMap(List<TclArgument> arguments, int pos, Switch sw) {
        HashMap<Group, Argument> fit = new HashMap<Group, Argument>();
        String prefix = null;
        TclArgument tclArgument = null;
        if (arguments != null && pos < arguments.size()) {
            tclArgument = arguments.get(pos);
            if (tclArgument != null) {
                if (tclArgument instanceof StringArgument) {
                    prefix = ((StringArgument)tclArgument).getValue();
                }
            } else {
                return fit;
            }
        }
        Map<Group, Argument> selectorsMap = this.getSwitchSelectorMap(sw);
        block0: for (Group group : selectorsMap.keySet()) {
            Argument selector = selectorsMap.get(group);
            if (selector instanceof Constant) {
                if (prefix == null) continue;
                if (sw.isCheckPrefix() && selector.getName().startsWith(prefix)) {
                    fit.put(group, selector);
                }
                if (!selector.getName().equals(prefix)) continue;
                fit.clear();
                fit.put(group, selector);
                break;
            }
            if (selector instanceof TypedArgument) {
                List<MatchResult> ress = this.matchDefinition(arguments, pos, selector);
                for (MatchResult r : ress) {
                    if (!r.isMatched()) continue;
                    fit.put(group, selector);
                    continue block0;
                }
                continue;
            }
            fit.put(group, selector);
        }
        return fit;
    }

    public Map<Group, Argument> getSwitchSelectorMap(Switch sw) {
        HashMap<Group, Argument> map = new HashMap<Group, Argument>();
        for (Group group : sw.getGroups()) {
            map.put(group, this.getFirstSelector(group));
        }
        return map;
    }

    public Argument getFirstSelector(Argument definition) {
        Argument selector = null;
        if (definition instanceof Constant || definition instanceof TypedArgument || definition instanceof ComplexArgument) {
            selector = DefinitionUtils.copyArgument(definition);
        } else if (definition instanceof Group) {
            Group group = (Group)definition;
            Constant constant = DefinitionUtils.extractGroupPseudoConstant(group);
            if (constant != null) {
                selector = constant;
            } else if (group.getArguments().size() > 0) {
                int i = 0;
                while (i < group.getArguments().size()) {
                    if (((Argument)group.getArguments().get(i)).getLowerBound() > 0) {
                        selector = this.getFirstSelector((Argument)group.getArguments().get(i));
                        break;
                    }
                    ++i;
                }
            }
        }
        return selector;
    }

    public List<Argument> getFinalSelectors(Argument definition) {
        ArrayList<Argument> selectors;
        block4: {
            block6: {
                Group group;
                block7: {
                    block5: {
                        selectors = new ArrayList<Argument>();
                        if (!(definition instanceof Constant) && !(definition instanceof TypedArgument) && !(definition instanceof ComplexArgument)) break block5;
                        selectors.add(DefinitionUtils.copyArgument(definition));
                        break block4;
                    }
                    if (!(definition instanceof Group)) break block6;
                    group = (Group)definition;
                    Constant constant = DefinitionUtils.extractGroupPseudoConstant(group);
                    if (constant == null) break block7;
                    selectors.add(constant);
                    break block4;
                }
                EList<Argument> groupArgs = group.getArguments();
                int groupArgsSize = groupArgs.size();
                if (groupArgsSize <= 0) break block4;
                int i = 0;
                while (i < groupArgsSize) {
                    Argument gArg = (Argument)groupArgs.get(i);
                    if (gArg.getLowerBound() > 0) {
                        selectors.addAll(this.getFinalSelectors(gArg));
                        break block4;
                    }
                    ++i;
                }
                break block4;
            }
            if (definition instanceof Switch) {
                Switch sw = (Switch)definition;
                for (Group group : sw.getGroups()) {
                    selectors.addAll(this.getFinalSelectors(group));
                }
            }
        }
        return selectors;
    }

    public TclErrorCollector getErrorReporter() {
        return this.errors;
    }

    private String[] getExtraArgs() {
        return null;
    }

    private void reportInvalidArgumentCount(int start, int end, int count, TclErrorCollector collector, Command definition) {
        String message = Messages.TclArgumentMatcher_Invlid_Arguments;
        collector.report(5, message, this.getExtraArgs(), start, end, ITclErrorConstants.ERROR);
    }

    private void reportInvalidArgumentValue(TclArgument argument, ArgumentType type, TclErrorCollector collector, String additional) {
        if (additional != null) {
            collector.report(11, NLS.bind((String)Messages.TclArgumentMatcher_Argument_Of_Type_ExpectedDetail, (Object[])new Object[]{this.synopsisBuilder.typeToString(type), this.synopsisBuilder.argumentToString(argument), additional}), this.getExtraArgs(), argument.getStart(), argument.getEnd(), ITclErrorReporter.ERROR);
        } else {
            collector.report(11, NLS.bind((String)Messages.TclArgumentMatcher_Argument_Of_Type_Expected, (Object[])new Object[]{this.synopsisBuilder.typeToString(type), this.synopsisBuilder.argumentToString(argument)}), this.getExtraArgs(), argument.getStart(), argument.getEnd(), ITclErrorReporter.ERROR);
        }
    }

    private void reportExtraArguments(List<TclArgument> list, int argumentsUsed, TclErrorCollector collector) {
        if (list.size() > argumentsUsed) {
            TclArgument begin = list.get(argumentsUsed);
            TclArgument end = list.get(list.size() - 1);
            String message = NLS.bind((String)Messages.TclArgumentMatcher_Extra_Arguments, (Object[])new Object[]{list.size() - argumentsUsed});
            collector.report(6, message, this.getExtraArgs(), begin.getStart(), end.getEnd(), ITclErrorConstants.WARNING);
        }
    }

    private void reportMissingArgument(Argument definitionArg, MatchResult r, int start, int end) {
        String value;
        String arg = this.synopsisBuilder.definitionToString(DefinitionUtils.minimizeBounds(definitionArg));
        if (definitionArg instanceof TypedArgument) {
            String type = this.synopsisBuilder.typeToString(((TypedArgument)definitionArg).getType()).toLowerCase();
            value = NLS.bind((String)Messages.TclArgumentMatcher_Missing_TypedArgument, (Object[])new Object[]{type, arg});
        } else {
            value = NLS.bind((String)Messages.TclArgumentMatcher_Missing_Argument, (Object[])new Object[]{arg});
        }
        r.getErrors().report(7, value, this.getExtraArgs(), start, end, ITclErrorReporter.ERROR);
    }

    private void reportMissingGroup(Group group, MatchResult r) {
        Argument selector = this.getFirstSelector(group);
        String message = NLS.bind((String)Messages.TclArgumentMatcher_Missing_Argument, (Object[])new Object[]{this.synopsisBuilder.definitionToString(selector)});
        r.getErrors().report(7, message, this.getExtraArgs(), this.command.getStart(), this.command.getEnd(), ITclErrorReporter.ERROR);
    }

    private void reportMissingSwitch(Switch sw, MatchResult r, TclArgument tclArgument) {
        ArrayList<TclArgument> arguments = new ArrayList<TclArgument>();
        arguments.add(tclArgument);
        Map<Group, Argument> fitGroups = this.getFitGroupMap(arguments, 0, sw);
        ArrayList<Argument> selectors = new ArrayList<Argument>();
        if (fitGroups.size() == 0) {
            for (Group group : sw.getGroups()) {
                selectors.addAll(this.getFinalSelectors(group));
            }
        } else {
            for (Group group : sw.getGroups()) {
                if (!fitGroups.containsKey(group)) continue;
                selectors.addAll(this.getFinalSelectors(group));
            }
        }
        String expected = this.synopsisBuilder.definitionToList(DefinitionUtils.minimizeBounds(selectors));
        String message = "";
        int code = 0;
        if (tclArgument != null) {
            message = NLS.bind((String)Messages.TclArgumentMatcher_Invalid_Arguments_And_Expected, (Object[])new Object[]{expected, this.synopsisBuilder.argumentToString(tclArgument)});
            code = 11;
            r.getErrors().report(code, message, this.getExtraArgs(), tclArgument.getStart(), tclArgument.getEnd(), ITclErrorReporter.ERROR);
            return;
        }
        message = NLS.bind((String)Messages.TclArgumentMatcher_Missing_Switch_Argument, (Object[])new Object[]{expected});
        code = 7;
        if (expected.length() == 0) {
            message = Messages.TclArgumentMatcher_Missing_Switch_Arg;
        }
        r.getErrors().report(code, message, this.getExtraArgs(), this.command.getStart(), this.command.getEnd(), ITclErrorReporter.ERROR);
    }

    public Map<Argument, int[]> getMappings() {
        return new HashMap<Argument, int[]>(this.mappings);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComplexArgumentResult {
        private List<Integer> blockArguments = new ArrayList<Integer>();
        private List<TclArgument> arguments = new ArrayList<TclArgument>();
        private int argumentNumber = -1;
        private ComplexArgument definition;
        private List<ComplexArgumentResult> complexArguments = new ArrayList<ComplexArgumentResult>();

        public List<ComplexArgumentResult> getComplexArguments() {
            return this.complexArguments;
        }

        public void setComplexArguments(List<ComplexArgumentResult> complexArguments) {
            this.complexArguments = complexArguments;
        }

        public int[] getBlockArguments() {
            return TclArgumentMatcher.getArrayFromList(this.blockArguments);
        }

        public List<Integer> getBlockArgumentsList() {
            return this.blockArguments;
        }

        public void setBlockArguments(List<Integer> blockArguments) {
            this.blockArguments = blockArguments;
        }

        public List<TclArgument> getArguments() {
            return this.arguments;
        }

        public void setArguments(List<TclArgument> arguments) {
            this.arguments = arguments;
        }

        public int getArgumentNumber() {
            return this.argumentNumber;
        }

        public void setArgumentNumber(int argumentNumber) {
            this.argumentNumber = argumentNumber;
        }

        public ComplexArgumentResult(int argumentNumber, List<TclArgument> arguments, List<Integer> blockArguments) {
            this.argumentNumber = argumentNumber;
            this.arguments = arguments;
            this.blockArguments = blockArguments;
        }

        public ComplexArgument getDefinition() {
            return this.definition;
        }

        public void setDefinition(ComplexArgument definition) {
            this.definition = definition;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ISinglePositionRule {
        public boolean check(TclArgument var1, Argument var2, List<Integer> var3, int var4, TclErrorCollector var5, List<ComplexArgumentResult> var6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MatchResult {
        public static final int POSSIBLE = -1;
        public static final int REGULAR = 0;
        public static final int IMPLICIT = 1;
        private int argumentsUsed = 0;
        private TclErrorCollector errors = new TclErrorCollector();
        private boolean matched = false;
        private boolean matchWithErrors = false;
        private int priority = 0;
        private List<Integer> blockArguments = new ArrayList<Integer>();
        private List<ComplexArgumentResult> complexArguments = new ArrayList<ComplexArgumentResult>();
        private Map<Argument, int[]> mapping = new HashMap<Argument, int[]>();

        private MatchResult() {
        }

        public int getArgumentsUsed() {
            return this.argumentsUsed;
        }

        public void setArgumentsUsed(int argumentsUsed) {
            this.argumentsUsed = argumentsUsed;
        }

        public boolean isMatched() {
            return this.matched;
        }

        public void setMatched(boolean matched) {
            this.matched = matched;
        }

        public boolean isImplicit() {
            return this.priority >= 1;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public void setSummaryPriorityOf(MatchResult r1, MatchResult r2) {
            this.priority = r1.getPriority() + r2.getPriority();
        }

        public void incrPriority() {
            ++this.priority;
        }

        public void decrPriority() {
            --this.priority;
        }

        public TclErrorCollector getErrors() {
            return this.errors;
        }

        public boolean isMatchWithErrors() {
            return this.matchWithErrors;
        }

        public void setMatchWithErrors(boolean matchWithErrors) {
            this.matchWithErrors = matchWithErrors;
        }

        public List<Integer> getBlockArguments() {
            return this.blockArguments;
        }

        public List<ComplexArgumentResult> getComplexArguments() {
            return this.complexArguments;
        }

        public Map<Argument, int[]> getMapping() {
            return this.mapping;
        }
    }

    private static class SubstitutedArgumentValue {
        String value;
        int offset = 0;

        private SubstitutedArgumentValue() {
        }
    }
}

