/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.spawnpoint;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.tcl.activestatedebugger.spawnpoint.SpawnpointCommandManager;
import org.eclipse.dltk.tcl.activestatedebugger.spawnpoint.TclSpawnpointMessages;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.indexing.SpawnpointCollector;
import org.eclipse.dltk.tcl.internal.validators.TclBuildContext;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.TclVisitor;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

public class TclSpawnpointBuildParticipant
implements IBuildParticipant {
    private final Set<String> spawnCommands = new HashSet<String>();

    public TclSpawnpointBuildParticipant(IProject project) {
        this.spawnCommands.addAll(SpawnpointCommandManager.load((IPreferencesLookupDelegate)new PreferencesLookupDelegate(project)).getSelectedCommands());
    }

    public void build(IBuildContext context) throws CoreException {
        if (context.getBuildType() == 10) {
            return;
        }
        IFile file = context.getFile();
        if (file == null) {
            return;
        }
        ISourceModule module = context.getSourceModule();
        if (module.getResource() == null) {
            return;
        }
        if (this.spawnCommands.isEmpty()) {
            return;
        }
        TclModule tclModule = TclBuildContext.getStatements((IBuildContext)context);
        EList commands = tclModule.getStatements();
        if (commands == null) {
            return;
        }
        SpawnpointCollector collector = new SpawnpointCollector(context, this.spawnCommands);
        TclParserUtils.traverse((List)commands, (TclVisitor)collector);
        IMarker[] markers = file.findMarkers("org.eclipse.dltk.tcl.activestatedebugger.spawnpoint", true, 0);
        if (markers != null && markers.length > 0) {
            file.deleteMarkers("org.eclipse.dltk.tcl.activestatedebugger.spawnpoint", true, 0);
        }
        if (!collector.spawnpoints.isEmpty()) {
            for (Map.Entry entry : collector.spawnpoints.entrySet()) {
                IMarker marker = file.createMarker("org.eclipse.dltk.tcl.activestatedebugger.spawnpoint");
                SpawnpointCollector.SpawnpointInfo info = (SpawnpointCollector.SpawnpointInfo)entry.getValue();
                marker.setAttributes(new String[]{"lineNumber", "charStart", "charEnd", "message"}, new Object[]{entry.getKey(), info.charStart, info.charEnd, this.buildMessage(info)});
            }
        }
    }

    private String buildMessage(SpawnpointCollector.SpawnpointInfo info) {
        return NLS.bind((String)TclSpawnpointMessages.participantMarkerMessage_template, (Object)TextUtils.join((Collection)info.commands, (char)','), (Object)(info.commands.size() == 1 ? TclSpawnpointMessages.participantMarkerMessage_commandSingular : TclSpawnpointMessages.participantMarkerMessage_commandPlurar));
    }
}

