/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;

public class BinaryExpression
extends Expression {
    private ASTNode left;
    private ASTNode right;
    protected int kind;

    public BinaryExpression(ASTNode left, int kind, ASTNode right) {
        if (left != null) {
            this.setStart(left.sourceStart());
        }
        if (right != null) {
            this.setEnd(right.sourceEnd());
        }
        this.kind = kind;
        this.left = left;
        this.right = right;
    }

    public ASTNode getLeft() {
        return this.left;
    }

    public ASTNode getRight() {
        return this.right;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Expression)this)) {
            if (this.left != null) {
                this.left.traverse(pVisitor);
            }
            if (this.right != null) {
                this.right.traverse(pVisitor);
            }
            pVisitor.endvisit((Expression)this);
        }
    }

    public String toString() {
        String out = "";
        if (this.left != null) {
            out = String.valueOf(out) + this.left.toString();
        }
        out = String.valueOf(out) + this.getOperator();
        if (this.right != null) {
            out = String.valueOf(out) + this.right.toString();
        }
        return out;
    }

    public int getKind() {
        return this.kind;
    }

    public void printNode(CorePrinter output) {
        if (this.left != null) {
            this.left.printNode(output);
        }
        output.formatPrintLn(this.getOperator());
        if (this.right != null) {
            this.right.printNode(output);
        }
    }
}

