/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.validators.checks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.TclVisitor;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.dltk.tcl.parser.definitions.IScopeProcessor;
import org.eclipse.dltk.tcl.parser.definitions.NamespaceScopeProcessor;
import org.eclipse.dltk.tcl.validators.ITclCheck;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandRedefinitionCheck
implements ITclCheck {
    @Override
    public void checkCommands(List<TclCommand> tclCommands, ITclErrorReporter reporter, Map<String, String> options, IScriptProject project, ISourceLineTracker sourceLineTracker) {
        NamespaceScopeProcessor processor = DefinitionManager.getInstance().createProcessor();
        TclParserUtils.traverse(tclCommands, (TclVisitor)new TclVisitor((IScopeProcessor)processor, reporter, sourceLineTracker){
            Map<String, Integer> userCommands = new HashMap<String, Integer>();
            private final /* synthetic */ IScopeProcessor val$processor;
            private final /* synthetic */ ITclErrorReporter val$reporter;
            private final /* synthetic */ ISourceLineTracker val$sourceLineTracker;
            {
                this.val$processor = iScopeProcessor;
                this.val$reporter = iTclErrorReporter;
                this.val$sourceLineTracker = iSourceLineTracker;
            }

            public boolean visit(TclCommand tclCommand) {
                Assert.isNotNull((Object)tclCommand);
                this.val$processor.processCommand(tclCommand);
                if (tclCommand.getDefinition() == null || !tclCommand.isMatched()) {
                    return true;
                }
                if ("proc".equals(tclCommand.getDefinition().getName())) {
                    Assert.isLegal((tclCommand.getArguments().size() >= 3 ? 1 : 0) != 0);
                    TclArgument nameArgument = (TclArgument)tclCommand.getArguments().get(0);
                    if (nameArgument instanceof StringArgument) {
                        Command[] definitions;
                        String current = ((StringArgument)nameArgument).getValue();
                        if ((current = this.val$processor.getQualifiedName(current)).startsWith("::")) {
                            current = current.substring(2);
                        }
                        if ((definitions = this.val$processor.getCommandDefinition(current)) != null && definitions.length != 0) {
                            this.val$reporter.report(9, "Built-in command redefinition", null, nameArgument.getStart(), nameArgument.getEnd(), ITclErrorReporter.WARNING);
                        }
                        Set<String> names = this.userCommands.keySet();
                        for (String name : names) {
                            if (!name.equals(current)) continue;
                            String msg = NLS.bind((String)"Procedure {0} is already defined on line {1}", (Object)name, (Object)this.userCommands.get(name));
                            this.val$reporter.report(10, msg, null, nameArgument.getStart(), nameArgument.getEnd(), ITclErrorReporter.WARNING);
                        }
                        int start = tclCommand.getStart();
                        this.userCommands.put(current, this.val$sourceLineTracker.getLineNumberOfOffset(start));
                    }
                }
                return true;
            }

            public void endVisit(TclCommand command) {
                this.val$processor.endProcessCommand();
            }
        });
    }
}

