/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.hover;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.internal.ui.editor.ScriptAnnotationIterator;
import org.eclipse.dltk.internal.ui.text.HTMLPrinter;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public abstract class AbstractAnnotationHover
extends AbstractScriptEditorTextHover {
    protected DefaultMarkerAnnotationAccess fAnnotationAccess = new DefaultMarkerAnnotationAccess();
    protected boolean fAllAnnotations;
    private IPreferenceStore combinedStore = null;

    public AbstractAnnotationHover(boolean allAnnotations) {
        this.fAllAnnotations = allAnnotations;
    }

    protected String postUpdateMessage(String message) {
        return message;
    }

    protected String formatMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.insertPageProlog(buffer, 0, AbstractAnnotationHover.getStyleSheet());
        buffer.append(this.postUpdateMessage(TextUtils.escapeHTML((String)message)));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    @Override
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IAnnotationModel model;
        IPath path;
        if (textViewer instanceof ISourceViewer) {
            path = null;
            model = ((ISourceViewer)textViewer).getAnnotationModel();
        } else {
            path = this.getEditorInputPath();
            model = this.getAnnotationModel(path);
        }
        if (model == null) {
            return null;
        }
        try {
            IPreferenceStore store = this.getCombinedPreferenceStore();
            ScriptAnnotationIterator e = new ScriptAnnotationIterator(model, this.fAllAnnotations);
            int layer = -1;
            String message = null;
            boolean multi = false;
            while (e.hasNext()) {
                String msg;
                Annotation a = (Annotation)e.next();
                AnnotationPreference preference = this.getAnnotationPreference(a);
                if (preference == null || !AbstractAnnotationHover.isActive(store, preference.getTextPreferenceKey()) && !AbstractAnnotationHover.isActive(store, preference.getHighlightPreferenceKey())) continue;
                Position p = model.getPosition(a);
                int l = this.fAnnotationAccess.getLayer(a);
                if (l < layer || p == null || !p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = this.getMessageFromAnnotation(a)) == null || msg.trim().length() <= 0) continue;
                if (message != null) {
                    message = String.valueOf(message) + "\n-" + msg;
                    multi = true;
                } else {
                    message = msg;
                }
                layer = l;
            }
            if (layer > -1) {
                if (multi) {
                    message = "Multiple markers:\n-" + message;
                }
                String string = this.formatMessage(message);
                return string;
            }
        }
        finally {
            try {
                if (path != null) {
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    manager.disconnect(path, LocationKind.NORMALIZE, null);
                }
            }
            catch (CoreException ex) {
                DLTKUIPlugin.log(ex.getStatus());
            }
        }
        return null;
    }

    protected String getMessageFromAnnotation(Annotation a) {
        return a.getText();
    }

    protected static boolean isActive(IPreferenceStore store, String preference) {
        return preference != null && store.getBoolean(preference);
    }

    protected synchronized IPreferenceStore getCombinedPreferenceStore() {
        if (this.combinedStore == null) {
            this.combinedStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return this.combinedStore;
    }

    protected IPath getEditorInputPath() {
        if (this.getEditor() == null) {
            return null;
        }
        IEditorInput input = this.getEditor().getEditorInput();
        if (input instanceof IStorageEditorInput) {
            try {
                return ((IStorageEditorInput)input).getStorage().getFullPath();
            }
            catch (CoreException ex) {
                DLTKUIPlugin.log(ex.getStatus());
            }
        }
        return null;
    }

    protected IAnnotationModel getAnnotationModel(IPath path) {
        if (path == null) {
            return null;
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            manager.connect(path, LocationKind.NORMALIZE, null);
        }
        catch (CoreException ex) {
            DLTKUIPlugin.log(ex.getStatus());
            return null;
        }
        IAnnotationModel model = null;
        try {
            IAnnotationModel iAnnotationModel = model = manager.getTextFileBuffer(path, LocationKind.NORMALIZE).getAnnotationModel();
            return iAnnotationModel;
        }
        finally {
            if (model == null) {
                try {
                    manager.disconnect(path, LocationKind.NORMALIZE, null);
                }
                catch (CoreException ex) {
                    DLTKUIPlugin.log(ex.getStatus());
                }
            }
        }
    }

    protected AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }
}

