/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser.definitions;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.definitions.Scope;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionExtensionManager;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionLoader;
import org.eclipse.dltk.tcl.parser.definitions.NamespaceScopeProcessor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionManager {
    private static DefinitionManager sInstance;
    private Map<String, Scope> scopes;
    private Map<URI, EObject> eobjectCache = new HashMap<URI, EObject>();
    private NamespaceScopeProcessor coreProcessor = null;

    private DefinitionManager() {
    }

    public Map<URI, EObject> getEobjectCache() {
        return this.eobjectCache;
    }

    private void initialize() {
        if (this.scopes == null) {
            URL[] locations;
            this.scopes = new HashMap<String, Scope>();
            Map<URL, String> extentions = DefinitionExtensionManager.getInstance().getExtentions();
            URL[] uRLArray = locations = DefinitionExtensionManager.getInstance().getLocations();
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                URL location = uRLArray[n2];
                try {
                    Scope scope = DefinitionLoader.loadDefinitions(location);
                    this.scopes.put(extentions.get(location), scope);
                    this.fillEObjects(scope);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }

    private void fillEObjects(Scope scope) {
        EList<Scope> children = scope.getChildren();
        for (Scope child : children) {
            this.fillEObjects(child);
        }
        if (scope instanceof Command) {
            Command command = (Command)scope;
            this.eobjectCache.put(EcoreUtil.getURI((EObject)command), command);
        }
    }

    public Scope getScope(String name) {
        this.initialize();
        return this.scopes.get(name);
    }

    public Scope[] getScopes() {
        this.initialize();
        Collection<Scope> values = this.scopes.values();
        return values.toArray(new Scope[values.size()]);
    }

    public NamespaceScopeProcessor createProcessor(String name) {
        NamespaceScopeProcessor processor = new NamespaceScopeProcessor();
        Scope scope = this.getScope(name);
        if (scope != null) {
            processor.addScope(scope);
        }
        return processor;
    }

    public NamespaceScopeProcessor createProcessor() {
        return new NamespaceScopeProcessor(this.internalCoreProcessor());
    }

    public NamespaceScopeProcessor createNewProcessor() {
        Scope[] scopes;
        NamespaceScopeProcessor processor = new NamespaceScopeProcessor();
        Scope[] scopeArray = scopes = this.getScopes();
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            Scope scope = scopeArray[n2];
            processor.addScope(scope);
            ++n2;
        }
        return processor;
    }

    private NamespaceScopeProcessor internalCoreProcessor() {
        if (this.coreProcessor == null) {
            this.coreProcessor = this.createNewProcessor();
        }
        return this.coreProcessor;
    }

    @Deprecated
    public NamespaceScopeProcessor getCoreProcessor() {
        return this.createProcessor();
    }

    public static synchronized DefinitionManager getInstance() {
        if (sInstance == null) {
            sInstance = new DefinitionManager();
        }
        return sInstance;
    }
}

