/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.debug;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.debug.core.ISmartStepEvaluator;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;

public class RubySmartStepEvaluator
implements ISmartStepEvaluator {
    public boolean isFiltered(String[] filters, IScriptThread thread) {
        block5: {
            String where;
            block6: {
                IStackFrame topFrame = thread.getTopStackFrame();
                if (!(topFrame instanceof IScriptStackFrame)) break block5;
                where = ((IScriptStackFrame)topFrame).getWhere();
                int colonPos = where.lastIndexOf("::");
                if (colonPos <= 0) break block6;
                String className = where.substring(0, colonPos);
                if (this.filter(className, filters)) {
                    return true;
                }
            }
            try {
                if (this.filter(where, filters)) {
                    return true;
                }
            }
            catch (DebugException e) {
                if (!DLTKCore.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean filter(String typeQualifiedName, String[] filters) {
        typeQualifiedName = typeQualifiedName.replaceAll("::", ".");
        int i = 0;
        while (i < filters.length) {
            if (filters[i].equals(typeQualifiedName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

