/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.internal.corext.refactoring.base.ScriptStatusContext;
import org.eclipse.dltk.internal.javascript.core.manipulation.JavascriptManipulationPlugin;
import org.eclipse.dltk.internal.javascript.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.OperatorPrecedence;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.ParameterData;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.SourceProvider;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.FlowContext;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.InputFlowAnalyzer;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.VariableBinding;
import org.eclipse.dltk.internal.javascript.corext.refactoring.util.Selection;
import org.eclipse.dltk.javascript.core.dom.BinaryExpression;
import org.eclipse.dltk.javascript.core.dom.BinaryOperator;
import org.eclipse.dltk.javascript.core.dom.BlockStatement;
import org.eclipse.dltk.javascript.core.dom.CallExpression;
import org.eclipse.dltk.javascript.core.dom.ConditionalExpression;
import org.eclipse.dltk.javascript.core.dom.DomFactory;
import org.eclipse.dltk.javascript.core.dom.DomPackage;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.ExpressionStatement;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.Identifier;
import org.eclipse.dltk.javascript.core.dom.IfStatement;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Parameter;
import org.eclipse.dltk.javascript.core.dom.ParenthesizedExpression;
import org.eclipse.dltk.javascript.core.dom.ReturnStatement;
import org.eclipse.dltk.javascript.core.dom.Statement;
import org.eclipse.dltk.javascript.core.dom.UnaryExpression;
import org.eclipse.dltk.javascript.core.dom.VariableDeclaration;
import org.eclipse.dltk.javascript.core.dom.VariableReference;
import org.eclipse.dltk.javascript.core.dom.VariableStatement;
import org.eclipse.dltk.javascript.core.dom.rewrite.RefactoringUtils;
import org.eclipse.dltk.javascript.core.dom.rewrite.VariableLookup;
import org.eclipse.dltk.javascript.core.dom.util.DomSwitch;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;

public class CallInliner {
    private ISourceModule cu;
    private SourceProvider sourceProvider;
    private Node bodyDeclaration;
    private CallExpression invocation;
    private Node targetNode;
    private FlowContext flowContext;
    private FlowInfo flowInfo;
    private Map<Identifier, VariableBinding> bindings;
    private Expression[] realArguments;
    private Set<String> usedNames;
    private List<String> locals;
    private List<Expression> localInitializers;
    private Expression receiverExpr;

    public CallInliner(ISourceModule cu, SourceProvider provider) throws CoreException {
        this.cu = cu;
        this.sourceProvider = provider;
    }

    public void initialize(Node declaration) {
        this.bodyDeclaration = declaration;
        this.bindings = VariableLookup.findBindings(declaration);
    }

    public RefactoringStatus initialize(CallExpression invocation, int severity) {
        RefactoringStatus result = new RefactoringStatus();
        this.invocation = invocation;
        this.locals = new ArrayList<String>();
        this.localInitializers = new ArrayList<Expression>();
        this.initializeTargetNode();
        this.flowAnalysis();
        try {
            this.computeRealArguments();
            this.computeReceiver();
        }
        catch (ModelException exception) {
            JavascriptManipulationPlugin.log(exception);
        }
        this.checkInvocationContext(result, severity);
        return result;
    }

    private void initializeTargetNode() {
        Node parent = (Node)this.invocation.eContainer();
        int nodeType = parent.eClass().getClassifierID();
        this.targetNode = nodeType == 35 || nodeType == 45 ? parent : this.invocation;
    }

    private void checkInvocationContext(RefactoringStatus result, int severity) {
        int nodeType = this.targetNode.eClass().getClassifierID();
        if (nodeType == 35) {
            if (this.sourceProvider.isExecutionFlowInterrupted()) {
                this.addEntry(result, RefactoringCoreMessages.CallInliner_execution_flow);
                return;
            }
        } else if (nodeType == 26) {
            VariableDeclaration decl;
            VariableStatement stmt;
            Node parent = (Node)this.targetNode.eContainer();
            int parentType = parent.eClass().getClassifierID();
            if (parentType == 45) {
                return;
            }
            if (this.sourceProvider.isExecutionFlowInterrupted()) {
                this.addEntry(result, RefactoringCoreMessages.CallInliner_execution_flow);
                return;
            }
            if (parentType == 28 && RefactoringUtils.isAssignment(((BinaryExpression)parent).getOperation()) && parent.eContainer().eClass().getClassifierID() == 35) {
                return;
            }
            if (parentType == 33 && (stmt = (VariableStatement)(decl = (VariableDeclaration)parent).eContainer()).getDeclarations().get(0) == decl) {
                return;
            }
            if (parentType == 25) {
                this.addEntry(result, RefactoringCoreMessages.CallInliner_constructors);
                return;
            }
            if (!this.sourceProvider.isSimpleFunction()) {
                if (CallInliner.isMultiDeclarationFragment(parent)) {
                    this.addEntry(result, RefactoringCoreMessages.CallInliner_multiDeclaration);
                } else {
                    this.addEntry(result, RefactoringCoreMessages.CallInliner_simple_functions);
                }
                return;
            }
        }
    }

    private static boolean isMultiDeclarationFragment(Node node) {
        return node instanceof VariableDeclaration && ((VariableStatement)node.eContainer()).getDeclarations().size() > 1;
    }

    private void addEntry(RefactoringStatus result, String message) {
        result.addEntry(new RefactoringStatusEntry(3, message, ScriptStatusContext.create((ISourceModule)this.cu, (ISourceRange)new SourceRange(this.invocation.getBegin(), this.invocation.getEnd() - this.invocation.getBegin())), JavascriptManipulationPlugin.getPluginId(), -1));
    }

    private void flowAnalysis() {
        this.flowContext = new FlowContext(this.bindings);
        this.flowContext.setConsiderAccessMode(true);
        this.flowContext.setComputeMode(FlowContext.Mode.ARGUMENTS);
        Selection selection = Selection.createFromStartLength(this.invocation.getBegin(), this.invocation.getEnd() - this.invocation.getBegin());
        this.flowInfo = new InputFlowAnalyzer(this.flowContext, selection, true).perform(this.bodyDeclaration);
    }

    private String getUnusedName(String candidate) {
        if (!this.usedNames.contains(candidate)) {
            this.usedNames.add(candidate);
            return candidate;
        }
        int i = 1;
        while (true) {
            String res;
            if (!this.usedNames.contains(res = String.valueOf(candidate) + i)) {
                this.usedNames.add(res);
                return res;
            }
            ++i;
        }
    }

    private Set<String> computeRealArguments() throws ModelException {
        EList<Expression> arguments = this.invocation.getArguments();
        Set<Expression> canNotInline = this.crossCheckArguments((List<Expression>)arguments);
        this.realArguments = new Expression[arguments.size()];
        this.usedNames = VariableLookup.getVisibleNames(this.invocation);
        int i = 0;
        while (i < arguments.size()) {
            ParameterData parameter;
            Expression expression = (Expression)arguments.get(i);
            if (this.canInline(expression, parameter = this.sourceProvider.getParameterData(i)) && !canNotInline.contains(expression)) {
                this.realArguments[i] = (Expression)EcoreUtil.copy((EObject)expression);
            } else {
                Identifier id = DomFactory.eINSTANCE.createIdentifier();
                String name = this.getUnusedName(parameter.getName());
                id.setName(name);
                VariableReference ref = DomFactory.eINSTANCE.createVariableReference();
                ref.setVariable(id);
                this.realArguments[i] = ref;
                this.locals.add(name);
                this.localInitializers.add(expression);
            }
            ++i;
        }
        return this.usedNames;
    }

    private void computeReceiver() {
        Expression receiver = RefactoringUtils.getReceiver(this.invocation);
        if (receiver == null) {
            this.receiverExpr = null;
            return;
        }
        switch (receiver.eClass().getClassifierID()) {
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.receiverExpr = receiver;
                return;
            }
        }
        if (this.sourceProvider.getReceiversToBeUpdated() != 1) {
            while (receiver instanceof ParenthesizedExpression) {
                Expression expr = ((ParenthesizedExpression)receiver).getEnclosed();
                if (expr instanceof BinaryExpression && ((BinaryExpression)expr).getOperation() == BinaryOperator.COMMA) break;
                receiver = expr;
            }
            this.localInitializers.add(receiver);
            Identifier id = DomFactory.eINSTANCE.createIdentifier();
            String name = this.getUnusedName("r");
            id.setName(name);
            this.locals.add(name);
            VariableReference ref = DomFactory.eINSTANCE.createVariableReference();
            ref.setVariable(id);
            this.receiverExpr = ref;
        } else {
            this.receiverExpr = receiver;
        }
    }

    private static boolean needsParentheses(Expression expression, Expression destination) {
        int inner = OperatorPrecedence.getExpressionPrecedence(expression);
        EReference feature = destination.eContainmentFeature();
        int outer = feature == DomPackage.eINSTANCE.getCallExpression_Arguments() ? 0 : (feature == DomPackage.eINSTANCE.getArrayLiteral_Elements() ? 0 : (feature == DomPackage.eINSTANCE.getParenthesizedExpression_Enclosed() ? -1 : (destination.eContainer() instanceof Expression ? OperatorPrecedence.getExpressionPrecedence((Expression)destination.eContainer()) : (destination.eContainer() instanceof VariableDeclaration ? 0 : -1))));
        for (Node node = destination; node != null; node = (Node)node.eContainer()) {
            EReference ref = node.eContainmentFeature();
            if (ref == DomPackage.eINSTANCE.getBinaryExpression_Left() || ref == DomPackage.eINSTANCE.getBinaryExpression_Right() || ref == DomPackage.eINSTANCE.getConditionalExpression_Predicate() || ref == DomPackage.eINSTANCE.getConditionalExpression_Alternative() || ref == DomPackage.eINSTANCE.getVariableDeclaration_Initializer() || ref == DomPackage.eINSTANCE.getVariableStatement_Declarations() || ref == DomPackage.eINSTANCE.getConstStatement_Declarations()) continue;
            if (ref != DomPackage.eINSTANCE.getForStatement_Initialization() && ref != DomPackage.eINSTANCE.getForInStatement_Item() && ref != DomPackage.eINSTANCE.getForEachInStatement_Item() || CallInliner.isNodeNoIn(expression)) break;
            return true;
        }
        if (inner != outer) {
            return inner < outer;
        }
        if (feature == DomPackage.eINSTANCE.getBinaryExpression_Right()) {
            return !RefactoringUtils.isAssignment(((BinaryExpression)destination.eContainer()).getOperation());
        }
        return false;
    }

    private static boolean isNodeNoIn(Node node) {
        switch (node.eClass().getClassifierID()) {
            case 28: {
                BinaryExpression be = (BinaryExpression)node;
                return be.getOperation() != BinaryOperator.IN && CallInliner.isNodeNoIn(be.getLeft()) && CallInliner.isNodeNoIn(be.getRight());
            }
            case 29: {
                ConditionalExpression ce = (ConditionalExpression)node;
                return CallInliner.isNodeNoIn(ce.getPredicate()) && CallInliner.isNodeNoIn(ce.getAlternative());
            }
        }
        return true;
    }

    private Set<Expression> crossCheckArguments(List<Expression> arguments) {
        HashSet<Expression> result = new HashSet<Expression>();
        for (Expression arg : arguments) {
            TreeIterator it = arg.eAllContents();
            while (it.hasNext()) {
                Expression expr;
                Node node = (Node)it.next();
                if (node.eClass().getClassifierID() == 28 && RefactoringUtils.isAssignment((expr = (BinaryExpression)node).getOperation())) {
                    result.add(expr);
                }
                if (node.eClass().getClassifierID() != 27 || !RefactoringUtils.hasSideEffect((expr = (UnaryExpression)node).getOperation())) continue;
                result.add(expr);
            }
        }
        return result;
    }

    private boolean canInline(Expression actualParameter, ParameterData formalParameter) {
        InlineEvaluator evaluator = new InlineEvaluator(formalParameter);
        evaluator.traverse(actualParameter);
        return evaluator.getResult();
    }

    public RefactoringStatus perform() {
        Node parentStatement = this.invocation;
        while (parentStatement.eContainmentFeature().getEReferenceType().getClassifierID() != 30) {
            parentStatement = (Node)parentStatement.eContainer();
        }
        Node container = (Node)parentStatement.eContainer();
        EReference ref = parentStatement.eContainmentFeature();
        int nos = this.sourceProvider.getDeclaration().getBody().getStatements().size() + this.locals.size();
        if (!ref.isMany() && (nos > 1 || this.needsBlockAroundDanglingIf())) {
            BlockStatement block = DomFactory.eINSTANCE.createBlockStatement();
            block.getStatements().add((Object)((Statement)parentStatement));
            container.eSet((EStructuralFeature)ref, block);
            container = block;
            ref = DomPackage.eINSTANCE.getBlockStatement_Statements();
        }
        List list = null;
        int idx = -1;
        if (ref.isMany()) {
            list = (List)container.eGet((EStructuralFeature)ref);
            idx = list.lastIndexOf(parentStatement);
        }
        if (!this.locals.isEmpty()) {
            int i = 0;
            for (String str : this.locals) {
                Expression init = this.localInitializers.get(i++);
                Identifier id = DomFactory.eINSTANCE.createIdentifier();
                id.setName(str);
                VariableDeclaration decl = DomFactory.eINSTANCE.createVariableDeclaration();
                decl.setIdentifier(id);
                decl.setInitializer(init);
                VariableStatement stmt = DomFactory.eINSTANCE.createVariableStatement();
                stmt.getDeclarations().add((Object)decl);
                list.add(idx++, stmt);
            }
        }
        FunctionExpression declCopy = (FunctionExpression)EcoreUtil.copy((EObject)this.sourceProvider.getDeclaration());
        if (!this.cu.equals(this.sourceProvider.getSourceModule())) {
            TreeIterator it = declCopy.eAllContents();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                node.setBegin(-1);
                node.setEnd(-1);
            }
        }
        Map<Identifier, VariableBinding> bindings = VariableLookup.findBindings(declCopy);
        HashMap<VariableBinding, Expression> replacements = new HashMap<VariableBinding, Expression>();
        int i = 0;
        while (i < this.realArguments.length) {
            VariableBinding binding = bindings.get(((Parameter)declCopy.getParameters().get(i)).getName());
            replacements.put(binding, this.realArguments[i]);
            ++i;
        }
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        stmts.addAll((Collection<Statement>)declCopy.getBody().getStatements());
        List<Identifier> references = VariableLookup.findReferences(declCopy.getBody(), this.usedNames);
        for (Identifier id : references) {
            VariableBinding binding = bindings.get(id);
            if (binding == null || replacements.containsKey(binding)) continue;
            Identifier var = DomFactory.eINSTANCE.createIdentifier();
            var.setName(this.getUnusedName(id.getName()));
            VariableReference expr = DomFactory.eINSTANCE.createVariableReference();
            expr.setVariable(var);
            replacements.put(binding, expr);
        }
        Node node = null;
        if (stmts.isEmpty() && this.targetNode != null) {
            if (ref.isMany()) {
                list.remove(idx);
            } else {
                container.eSet((EStructuralFeature)ref, DomFactory.eINSTANCE.createEmptyStatement());
            }
        } else {
            int i2 = 0;
            while (i2 < stmts.size() - 1) {
                list.add(idx++, (Statement)stmts.get(i2));
                ++i2;
            }
            node = (Node)stmts.get(stmts.size() - 1);
            if (node.eClass().getClassifierID() == 45) {
                node = ((ReturnStatement)node).getExpression();
                if (this.targetNode instanceof Expression) {
                    if (CallInliner.needsParentheses((Expression)node, (Expression)this.targetNode)) {
                        ParenthesizedExpression pExp = DomFactory.eINSTANCE.createParenthesizedExpression();
                        pExp.setEnclosed((Expression)node);
                        node = pExp;
                    }
                    Node cont = (Node)this.targetNode.eContainer();
                    EReference target = this.targetNode.eContainmentFeature();
                    if (target.isMany()) {
                        List targets = (List)cont.eGet((EStructuralFeature)target);
                        targets.set(targets.lastIndexOf(this.targetNode), (Expression)node);
                    } else {
                        cont.eSet((EStructuralFeature)target, node);
                    }
                } else if (this.targetNode.eClass().getClassifierID() == 35) {
                    if (this.sourceProvider.mustEvaluateReturnedExpression()) {
                        ExpressionStatement stmt = DomFactory.eINSTANCE.createExpressionStatement();
                        stmt.setExpression((Expression)node);
                        list.set(idx, stmt);
                    } else {
                        list.remove(idx);
                    }
                } else {
                    list.set(idx, (Statement)stmts.get(stmts.size() - 1));
                }
            } else {
                list.set(idx, (Statement)stmts.get(stmts.size() - 1));
            }
        }
        new ReceiverAnalyzer(replacements, bindings).traverse(stmts, node);
        return new RefactoringStatus();
    }

    private boolean needsBlockAroundDanglingIf() {
        return this.targetNode.eContainmentFeature() == DomPackage.eINSTANCE.getIfStatement_Consequent() && ((IfStatement)this.targetNode.eContainer()).getAlternative() == null && this.sourceProvider.isDanglingIf();
    }

    private class InlineEvaluator
    extends DomSwitch<Boolean> {
        private ParameterData formalArgument;
        private boolean result;

        public InlineEvaluator(ParameterData argument) {
            this.formalArgument = argument;
        }

        public boolean getResult() {
            return this.result;
        }

        public void traverse(Node node) {
            int accessMode = this.formalArgument.getSimplifiedAccessMode();
            switch (node.eClass().getClassifierID()) {
                case 3: {
                    VariableBinding binding = (VariableBinding)CallInliner.this.bindings.get(((VariableReference)node).getVariable());
                    this.result = accessMode == 2 || accessMode == 1 || CallInliner.this.flowInfo.hasAccessMode(CallInliner.this.flowContext, binding, 9);
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.result = accessMode != 8;
                    break;
                }
                case 22: {
                    this.traverse(((ParenthesizedExpression)node).getEnclosed());
                    break;
                }
                case 23: 
                case 24: {
                    this.result = accessMode == 1 || accessMode == 2 && this.formalArgument.getNumberOfAccesses() <= 1;
                    this.result = this.result && !this.formalArgument.isFunction();
                    break;
                }
                default: {
                    this.result = accessMode == 1 || accessMode == 2 && this.formalArgument.getNumberOfAccesses() <= 1;
                }
            }
        }
    }

    private final class ReceiverAnalyzer {
        private final Map<VariableBinding, Expression> replacements;
        private final Map<Identifier, VariableBinding> bindings;

        private ReceiverAnalyzer(Map<VariableBinding, Expression> replacements, Map<Identifier, VariableBinding> bindings) {
            this.replacements = replacements;
            this.bindings = bindings;
        }

        void traverse(List<? extends Node> list, Node node) {
            this.traverse(list);
            if (node != null) {
                this.traverse(node);
            }
        }

        void traverse(List<? extends Node> list) {
            int i = 0;
            while (i < list.size()) {
                Expression expr = this.process(list.get(i));
                if (expr != null) {
                    list.set(i, expr);
                }
                ++i;
            }
        }

        void traverse(Node node) {
            for (EReference ref : node.eClass().getEAllReferences()) {
                if (ref.isMany()) {
                    this.traverse((List)node.eGet((EStructuralFeature)ref));
                    continue;
                }
                Expression expr = this.process((Node)node.eGet((EStructuralFeature)ref));
                if (expr == null) continue;
                node.eSet((EStructuralFeature)ref, expr);
            }
        }

        Expression process(Node value) {
            if (value == null) {
                return null;
            }
            switch (value.eClass().getClassifierID()) {
                case 2: {
                    VariableBinding binding = this.bindings.get((Identifier)value);
                    Expression res = this.replacements.get(binding);
                    if (res == null) {
                        return null;
                    }
                    if (res instanceof VariableReference) {
                        ((Identifier)value).setName(((VariableReference)res).getVariable().getName());
                        return null;
                    }
                    throw new IllegalStateException("Replacing variable with expression without removing declaration");
                }
                case 3: {
                    VariableBinding binding = this.bindings.get(((VariableReference)value).getVariable());
                    if (binding == null) {
                        return null;
                    }
                    Expression res = this.replacements.get(binding);
                    if (res != null) {
                        if (CallInliner.needsParentheses(res = (Expression)EcoreUtil.copy((EObject)res), (Expression)value)) {
                            ParenthesizedExpression pExp = DomFactory.eINSTANCE.createParenthesizedExpression();
                            pExp.setEnclosed(res);
                            res = pExp;
                        }
                        return res;
                    }
                    return null;
                }
                case 11: {
                    return CallInliner.this.receiverExpr == null ? null : (Expression)EcoreUtil.copy((EObject)CallInliner.this.receiverExpr);
                }
            }
            this.traverse(value);
            return null;
        }
    }
}

