/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.javascript.structure.IDeclaration;
import org.eclipse.dltk.javascript.structure.IParentNode;
import org.eclipse.dltk.javascript.structure.IScope;
import org.eclipse.dltk.javascript.structure.IStructureContext;
import org.eclipse.dltk.javascript.structure.IStructureNode;
import org.eclipse.dltk.javascript.structure.IStructureRequestor;
import org.eclipse.dltk.javascript.structure.ParentNode;

public abstract class Scope
extends ParentNode
implements IScope {
    private final List<IStructureNode> children = new ArrayList<IStructureNode>();

    public Scope(IParentNode parent) {
        super(parent);
    }

    @Override
    public IScope getScope() {
        return this;
    }

    @Override
    protected boolean isStructureKnown() {
        return false;
    }

    @Override
    public void addChild(IStructureNode child) {
        assert (child != null);
        this.children.add(child);
    }

    @Override
    public List<? extends IStructureNode> getChildren() {
        return this.children;
    }

    @Override
    public boolean isManyChildren() {
        return true;
    }

    @Override
    public IDeclaration resolve(String name) {
        for (IStructureNode child : this.children) {
            IDeclaration declaration;
            if (!(child instanceof IDeclaration) || !name.equals((declaration = (IDeclaration)child).getName())) continue;
            return declaration;
        }
        return this.parent != null ? this.parent.getScope().resolve(name) : null;
    }

    @Override
    public void reportStructure(IStructureRequestor requestor, IStructureContext context) {
        this.reportChildrenStructure(requestor, context);
    }
}

