/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.NodeWithChildren;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeIterator
implements Iterator<Node> {
    private String path = null;
    private List<NodeWithChildren> stack = new ArrayList<NodeWithChildren>();
    private int[] cursorStack = new int[100];

    public TreeIterator(NodeWithChildren start) {
        this.push(start);
    }

    public String getPath() {
        if (this.path == null) {
            NodeWithChildren n = this.currentNode();
            this.path = n.getType() == XMLTokenizer.Type.DOCUMENT ? "/" : ((Element)n).getChildPath();
        }
        return this.path;
    }

    protected void push(NodeWithChildren node) {
        this.stack.add(node);
        this.setCursor(0);
        this.path = null;
    }

    protected NodeWithChildren pop() {
        NodeWithChildren node = this.stack.remove(this.stack.size() - 1);
        this.path = null;
        return node;
    }

    public NodeWithChildren currentNode() {
        return this.stack.get(this.stack.size() - 1);
    }

    protected void setCursor(int i) {
        this.cursorStack[this.stack.size() - 1] = i;
    }

    protected void incCursor() {
        int n = this.stack.size() - 1;
        this.cursorStack[n] = this.cursorStack[n] + 1;
    }

    protected int getCursor() {
        return this.cursorStack[this.stack.size() - 1];
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.stack.isEmpty()) {
                return false;
            }
            if (this.getCursor() != this.currentNode().nodeCount()) break;
            this.pop();
        }
        return true;
    }

    @Override
    public Node next() {
        Element e;
        Node n = this.currentNode().getNode(this.getCursor());
        this.incCursor();
        if (XMLUtils.isElement(n) && (e = (Element)n).hasNodes()) {
            this.push(e);
        }
        return n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }
}

