/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.TextNode;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.XMLUtils;

public class Text
extends BasicNode
implements TextNode {
    private String text;

    public Text(Token token) {
        super(token);
    }

    public Text(XMLTokenizer.Type type, String text) {
        super(type, type == XMLTokenizer.Type.CDATA ? "<![CDATA[" + text + "]]>" : XMLUtils.escapeXMLText(text));
        this.text = text;
    }

    public Text(String text) {
        this(XMLTokenizer.Type.TEXT, text);
        this.text = text;
    }

    public boolean isCDATA() {
        return this.getType() == XMLTokenizer.Type.CDATA;
    }

    public String getText() {
        if (this.text == null) {
            String s = this.getValue();
            if (this.isCDATA()) {
                s = s.substring(9, s.length() - 3);
            }
            this.text = s;
        }
        return this.text;
    }

    public Text setText(String text) {
        this.setValue(this.getType() == XMLTokenizer.Type.CDATA ? "<![CDATA[" + text + "]]>" : XMLUtils.escapeXMLText(text));
        this.text = text;
        return this;
    }

    public String getTrimmedText() {
        return this.getText().trim();
    }

    public String getNormalizedText() {
        return this.getTrimmedText().replaceAll("\\s+", " ");
    }

    public boolean isWhitespace() {
        String s = this.getText();
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public Text createClone() {
        return new Text(this.getType(), null);
    }

    public BasicNode copy(Node orig) {
        super.copy(orig);
        Text other = (Text)orig;
        this.text = other.text;
        return this;
    }

    public Text copy() {
        return (Text)super.copy();
    }
}

