/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.Child;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.NodeFilter;
import de.pdark.decentxml.Parent;
import de.pdark.decentxml.XMLWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeWithChildren
implements Parent {
    private List<Node> nodes;

    @Override
    public NodeWithChildren addNode(Node node) {
        this.addNode(this.nodes == null ? 0 : this.nodes.size(), node);
        return this;
    }

    @Override
    public NodeWithChildren addNode(int index, Node node) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<Node>();
        }
        this.nodes.add(index, node);
        if (node instanceof Child) {
            Child child = (Child)node;
            child.setParent(this);
        }
        return this;
    }

    @Override
    public NodeWithChildren addNodes(Collection<? extends Node> nodes) {
        return this.addNodes(this.nodes == null ? 0 : this.nodes.size(), (Collection)nodes);
    }

    @Override
    public NodeWithChildren addNodes(int index, Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            this.addNode(index++, node);
        }
        return this;
    }

    @Override
    public NodeWithChildren addNodes(Node ... nodes) {
        return this.addNodes(this.nodes == null ? 0 : this.nodes.size(), nodes);
    }

    @Override
    public NodeWithChildren addNodes(int index, Node ... nodes) {
        for (Node node : nodes) {
            this.addNode(index++, node);
        }
        return this;
    }

    @Override
    public List<Node> getNodes() {
        if (this.nodes == null) {
            return Collections.emptyList();
        }
        return this.nodes;
    }

    @Override
    public boolean hasNodes() {
        return this.nodeCount() != 0;
    }

    @Override
    public int nodeCount() {
        return this.nodes == null ? 0 : this.nodes.size();
    }

    @Override
    public int nodeIndexOf(Node node) {
        if (this.nodes == null) {
            return -1;
        }
        return this.nodes.indexOf(node);
    }

    @Override
    public Node getNode(int index) {
        if (this.nodes == null) {
            throw new IndexOutOfBoundsException("Cannot return child " + index + ", node has only " + 0 + " child nodes");
        }
        if (index < 0 || index >= this.nodes.size()) {
            throw new IndexOutOfBoundsException("Cannot return child " + index + ", node has only " + this.nodes.size() + " child nodes");
        }
        return this.nodes.get(index);
    }

    @Override
    public Node removeNode(int index) {
        Node n = this.nodes.remove(index);
        if (n instanceof Child) {
            ((Child)n).setParent(null);
        }
        return n;
    }

    @Override
    public boolean removeNode(Node n) {
        if (this.nodes == null) {
            return false;
        }
        if (this.nodes.remove(n)) {
            if (n instanceof Child) {
                ((Child)n).setParent(null);
            }
            return true;
        }
        return false;
    }

    public <T> List<T> getNodes(NodeFilter<T> filter) {
        if (this.nodes == null) {
            return Collections.emptyList();
        }
        ArrayList<Node> result = new ArrayList<Node>(this.nodes.size());
        for (Node n : this.nodes) {
            if (!filter.matches(n)) continue;
            result.add(n);
        }
        return result;
    }

    @Override
    public NodeWithChildren clearNodes() {
        if (this.nodes != null) {
            this.nodes.clear();
        }
        return this;
    }

    @Override
    public String toXML() {
        return BasicNode.toXML(this);
    }

    @Override
    public NodeWithChildren toXML(XMLWriter writer) throws IOException {
        writer.writeChildNodes(this);
        return this;
    }

    public String toString() {
        return this.toXML();
    }

    @Override
    public NodeWithChildren copy(Node orig) {
        NodeWithChildren other = (NodeWithChildren)orig;
        if (other.nodes != null) {
            for (Node n : other.nodes) {
                Node copy = n.createClone();
                copy.copy(n);
                this.addNode(copy);
            }
        }
        return this;
    }

    @Override
    public NodeWithChildren copy() {
        NodeWithChildren n = (NodeWithChildren)this.createClone();
        n.copy(this);
        return n;
    }
}

