/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Child;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Entity;
import de.pdark.decentxml.Namespace;
import de.pdark.decentxml.Namespaces;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.NodeFilter;
import de.pdark.decentxml.NodeWithChildren;
import de.pdark.decentxml.Parent;
import de.pdark.decentxml.ProcessingInstruction;
import de.pdark.decentxml.Text;
import de.pdark.decentxml.TextNode;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLDeclaration;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.XMLUtils;
import de.pdark.decentxml.XMLWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends NodeWithChildren
implements Child,
TextNode {
    private Token startToken;
    private Namespace namespace;
    private String beginName;
    private String postSpace = "";
    private String endName;
    private String name;
    private Parent parent;
    private Map<String, Attribute> attributeMap;
    private boolean compactEmpty;
    public static final NodeFilter<Element> ELEMENT_FILTER = new NodeFilter<Element>(){

        @Override
        public boolean matches(Node n) {
            return n instanceof Element;
        }
    };

    public Element(Token token) {
        this.startToken = token;
        this.beginName = token.getText().substring(1);
        this.name = this.beginName.trim();
        this.setNamespace(null);
    }

    public Element(String name) {
        this(null, name);
    }

    public Element(Parent parent, String name) {
        this(parent, name, null);
    }

    public Element(String name, Namespace ns) {
        this(null, name, ns);
    }

    public Element(Parent parent, String name, Namespace ns) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("name is blank");
        }
        this.parent = parent;
        this.name = name;
        this.compactEmpty = true;
        this.setNamespace(ns);
        if (parent != null) {
            parent.addNode(this);
        }
    }

    public Token getStartToken() {
        return this.startToken;
    }

    public int getStartOffset() {
        return this.startToken == null ? -1 : this.startToken.getStartOffset();
    }

    public int getEndOffset() {
        return this.startToken == null ? -1 : this.startToken.getEndOffset();
    }

    public String getBeginName() {
        return this.beginName == null ? this.name : this.beginName;
    }

    public Element setBeginName(String beginName) {
        this.beginName = beginName;
        return this;
    }

    public String getEndName() {
        return this.endName == null ? this.name : this.endName;
    }

    public Element setEndName(String endName) {
        this.endName = endName;
        return this;
    }

    public String getPostSpace() {
        return this.postSpace;
    }

    public Element setPostSpace(String postSpace) {
        this.postSpace = postSpace;
        return this;
    }

    public Element setName(String name) {
        this.name = name;
        this.beginName = null;
        this.endName = null;
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Parent getParent() {
        return this.parent;
    }

    @Override
    public Element setParent(Parent parent) {
        this.parent = parent;
        return this;
    }

    public Element addAttributes(Attribute ... attributes) {
        for (Attribute node : attributes) {
            this.addAttribute(node);
        }
        return this;
    }

    public Element addAttribute(String name, String value) {
        return this.addAttribute(new Attribute(name, value));
    }

    public Element addAttribute(Attribute a) {
        String name;
        if (this.attributeMap == null) {
            this.attributeMap = new LinkedHashMap<String, Attribute>();
        }
        if (this.attributeMap.containsKey(name = a.getName())) {
            Token token = a.getToken();
            if (token != null) {
                throw new XMLParseException("There is already an attribute with the name " + name, token);
            }
            throw new XMLParseException("There is already an attribute with the name " + name, this);
        }
        this.attributeMap.put(name, a);
        if (name.startsWith("xmlns:")) {
            Namespaces namespaces = null;
            Document doc = this.getDocument();
            if (doc != null) {
                namespaces = doc.getNamespaces();
            }
            if (namespaces != null) {
                namespaces.addNamespace(new Namespace(name.substring("xmlns:".length()), a.getValue()));
            }
        }
        return this;
    }

    public Element setAttribute(Attribute a) {
        Attribute existing = this.getAttribute(a.getName());
        if (existing == null) {
            this.addAttribute(a);
        } else {
            existing.copy(a);
        }
        return this;
    }

    public List<Attribute> getAttributes() {
        if (this.attributeMap == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Attribute>(this.attributeMap.values());
    }

    public Map<String, Attribute> getAttributeMap() {
        if (this.attributeMap == null) {
            return Collections.emptyMap();
        }
        return this.attributeMap;
    }

    public Attribute getAttribute(String name, Namespace ns) {
        if (ns == null || ns.getPrefix().length() == 0) {
            return this.getAttribute(name);
        }
        return this.getAttribute(ns.getPrefix() + ":" + name);
    }

    public Attribute getAttribute(String name) {
        Attribute a = this.getAttributeMap().get(name);
        if (a != null || name.contains(":")) {
            return a;
        }
        for (Attribute a2 : this.getAttributeMap().values()) {
            String aName = a2.getName();
            int pos = aName.indexOf(58);
            if (pos == -1 || !name.equals(aName = aName.substring(pos + 1))) continue;
            return a2;
        }
        return null;
    }

    public Element setAttribute(String name, String value) {
        return this.setAttribute(name, value, null);
    }

    public Element setAttribute(String name, String value, Namespace ns) {
        Attribute a = this.getAttribute(name, ns);
        if (a == null) {
            a = new Attribute(name, value, ns);
            this.addAttribute(a);
        } else {
            a.setValue(value);
        }
        return this;
    }

    public Element checkMandatoryAttribute(String name) {
        Attribute a = this.getAttribute(name);
        if (a == null) {
            throw new XMLParseException("Element " + this.getName() + " has no attribute " + name);
        }
        return this;
    }

    public Element removeAttribute(String name) {
        if (this.attributeMap != null) {
            this.attributeMap.remove(name);
        }
        return this;
    }

    public String getAttributeValue(String name) {
        return this.getAttributeValue(name, null);
    }

    public String getAttributeValue(String name, Namespace ns) {
        Attribute a = this.getAttribute(name, ns);
        return a == null ? null : a.getValue();
    }

    @Override
    public Element addNode(Node node) {
        super.addNode(node);
        return this;
    }

    @Override
    public Element addNode(int index, Node node) {
        switch (node.getType()) {
            case CDATA: 
            case COMMENT: 
            case CUSTOM_ELEMENT: 
            case ELEMENT: 
            case TEXT: 
            case ENTITY: {
                break;
            }
            case PROCESSING_INSTRUCTION: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                if (!XMLDeclaration.isXMLDeclaration(pi)) break;
                if (pi.getToken() != null) {
                    throw new XMLParseException("The XML declaration must be the first node of the document", pi.getToken());
                }
                throw new XMLParseException("The XML declaration must be the first node of the document", this);
            }
            default: {
                throw new XMLParseException("The node " + (Object)((Object)node.getType()) + " is not allowed here", this);
            }
        }
        super.addNode(index, node);
        return this;
    }

    @Override
    public Element addNodes(Collection<? extends Node> nodes) {
        super.addNodes((Collection)nodes);
        return this;
    }

    @Override
    public Element addNodes(int index, Collection<? extends Node> nodes) {
        super.addNodes(index, (Collection)nodes);
        return this;
    }

    @Override
    public Element addNodes(Node ... nodes) {
        super.addNodes(nodes);
        return this;
    }

    @Override
    public Element addNodes(int index, Node ... nodes) {
        super.addNodes(index, nodes);
        return this;
    }

    public Element setCompactEmpty(boolean compactEmpty) {
        this.compactEmpty = compactEmpty;
        return this;
    }

    public boolean isCompactEmpty() {
        return this.compactEmpty && !this.hasNodes();
    }

    @Override
    public Element toXML(XMLWriter writer) throws IOException {
        writer.write(this);
        return this;
    }

    @Override
    public XMLTokenizer.Type getType() {
        return XMLTokenizer.Type.ELEMENT;
    }

    public Element getChild(int index) {
        int count = 0;
        if (this.hasNodes()) {
            for (Node n : this.getNodes()) {
                if (!XMLUtils.isElement(n)) continue;
                if (index == count) {
                    return (Element)n;
                }
                ++count;
            }
        }
        throw new IndexOutOfBoundsException("Cannot return child " + index + ", node has only " + count + (count == 1 ? " child" : " children"));
    }

    public boolean hasChildren() {
        if (!this.hasNodes()) {
            return false;
        }
        for (Node node : this.getNodes()) {
            if (!XMLUtils.isElement(node)) continue;
            return true;
        }
        return false;
    }

    public List<Element> getChildren() {
        return this.getNodes(ELEMENT_FILTER);
    }

    public List<Element> getChildren(String name) {
        return this.getChildren(name, null);
    }

    public List<Element> getChildren(final String name, final Namespace ns) {
        NodeFilter<Element> nameFilter = new NodeFilter<Element>(){

            @Override
            public boolean matches(Node n) {
                if (!XMLUtils.isElement(n)) {
                    return false;
                }
                Element e = (Element)n;
                boolean match = true;
                if (match && name != null && !e.getName().equals(name)) {
                    match = false;
                }
                if (match && ns != null && !ns.equals(Element.this.getNamespace())) {
                    match = false;
                }
                return match;
            }
        };
        return this.getNodes(nameFilter);
    }

    public Element clearChildNodes() {
        return this.clearChildren();
    }

    public Element clearChildren() {
        if (!this.hasNodes()) {
            return this;
        }
        Iterator<Node> iter = this.getNodes().iterator();
        while (iter.hasNext()) {
            Node n = iter.next();
            if (!XMLUtils.isElement(n)) continue;
            iter.remove();
        }
        return this;
    }

    @Override
    public String getText() {
        if (!this.hasNodes()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (Node n : this.getNodes()) {
            if (XMLUtils.isText(n)) {
                buffer.append(((Text)n).getText());
                continue;
            }
            if (XMLUtils.isElement(n)) {
                buffer.append(((Element)n).getText());
                continue;
            }
            if (n.getType() != XMLTokenizer.Type.ENTITY) continue;
            buffer.append(((Entity)n).getText());
        }
        return buffer.toString();
    }

    public String getTrimmedText() {
        return this.getText().trim();
    }

    public String getNormalizedText() {
        return this.getTrimmedText().replaceAll("\\s+", " ");
    }

    @Override
    public Element setText(String text) {
        this.clearText();
        this.addNode(0, new Text(text));
        return this;
    }

    public Element clearText() {
        if (!this.hasNodes()) {
            return this;
        }
        Iterator<Node> iter = this.getNodes().iterator();
        while (iter.hasNext()) {
            Node n = iter.next();
            if (XMLUtils.isText(n)) {
                iter.remove();
                continue;
            }
            if (!XMLUtils.isElement(n)) continue;
            ((Element)n).clearText();
        }
        return this;
    }

    public Element getParentElement() {
        if (this.getParent() == null || this.getParent().getType() == XMLTokenizer.Type.DOCUMENT) {
            return null;
        }
        return (Element)this.getParent();
    }

    @Override
    public String getNodePath() {
        return this.getChildPath();
    }

    public String getChildPath() {
        if (this.getParent() == null) {
            return this.getName();
        }
        Element p = this.getParentElement();
        if (p == null) {
            return "/" + this.getName();
        }
        int index = p.childIndexOf(this);
        if (index == 0) {
            return p.getChildPath() + "/" + this.getName();
        }
        return p.getChildPath() + "/" + this.getName() + "[" + index + "]";
    }

    public int childIndexOf(Element element) {
        int index = 0;
        for (Node n : this.getNodes()) {
            if (n.equals(element)) {
                return index;
            }
            if (!XMLUtils.isElement(n)) continue;
            ++index;
        }
        return -1;
    }

    public Document getDocument() {
        Parent p = this.getParent();
        while (p != null) {
            if (p.getType() == XMLTokenizer.Type.DOCUMENT) {
                return (Document)p;
            }
            p = ((Child)((Object)p)).getParent();
        }
        return null;
    }

    @Override
    public Element getChild(String path) {
        return this.getChild(path, null);
    }

    public Element getChild(String path, Namespace ns) {
        if (path.startsWith("/")) {
            Document doc = this.getDocument();
            return doc == null ? null : doc.getChild(path, ns);
        }
        if ((path.length() == 0 || ".".equals(path)) && (ns == null || ns.equals(this.getNamespace()))) {
            return this;
        }
        if (!this.hasNodes()) {
            return null;
        }
        String[] pathSegments = path.split("/");
        Element current = this;
        for (int i = 0; i < pathSegments.length; ++i) {
            String name = pathSegments[i];
            int pos = name.indexOf(58);
            Namespace ns2 = null;
            if (pos >= 0) {
                String prefix = name.substring(0, pos);
                name = name.substring(pos + 1);
                ns2 = this.getDocument().getNamespace(prefix);
                if (ns2 == null) {
                    throw new XMLParseException("Namespace prefix '" + prefix + "' is not defined");
                }
            }
            pos = name.indexOf(91);
            int index = 0;
            if (pos != -1) {
                int pos2 = name.indexOf(93, pos);
                index = Integer.parseInt(name.substring(pos + 1, pos2));
                name = name.substring(0, pos);
            }
            int count = 0;
            boolean found = false;
            for (Node n : current.getNodes()) {
                Element e;
                if (!(n instanceof Element) || !name.equals((e = (Element)n).getName()) || ns2 != null && !ns2.equals(e.getNamespace())) continue;
                if (count == index) {
                    current = e;
                    found = true;
                    break;
                }
                ++count;
            }
            if (found) continue;
            return null;
        }
        if (ns != null && !ns.equals(current.getNamespace())) {
            return null;
        }
        return current;
    }

    @Override
    public Element createClone() {
        return new Element(this.name);
    }

    @Override
    public Element copy(Node orig) {
        super.copy(orig);
        Element other = (Element)orig;
        if (other.attributeMap != null) {
            for (Attribute a : other.attributeMap.values()) {
                this.addAttribute(a.copy());
            }
        }
        this.beginName = other.beginName;
        this.compactEmpty = other.compactEmpty;
        this.endName = other.endName;
        this.name = other.name;
        this.postSpace = other.postSpace;
        this.startToken = other.startToken;
        return this;
    }

    @Override
    public Element copy() {
        return (Element)super.copy();
    }

    public void setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        this.namespace = namespace;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public void remove() {
        if (null == this.getParent()) {
            return;
        }
        this.getParent().removeNode(this);
    }
}

