/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.voice.preferences.util;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboFieldEditor
extends FieldEditor {
    Combo comboField;
    private String[][] labelsAndValues;
    protected String value;

    protected ComboFieldEditor(String name, String labelText, String[][] labelsAndValues, Composite parent) {
        this.init(name, labelText);
        this.initLabelsAndValues(labelsAndValues);
        this.createControl(parent);
        this.setEnabled(this.comboField.getItemCount() > 0, parent);
    }

    protected void initLabelsAndValues(String[][] labelsAndValues) {
        assert (this.checkArray(labelsAndValues));
        this.labelsAndValues = labelsAndValues;
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.comboField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.comboField = this.getComboControl(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns - 1;
        this.comboField.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.updateValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.value != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.value);
        } else {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        int i = 0;
        while (i < table.length) {
            String[] array = table[i];
            if (array == null || array.length != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void updateValue(String selectedValue) {
        if (selectedValue != null) {
            int i = 0;
            while (i < this.labelsAndValues.length) {
                if (this.labelsAndValues[i][1].equals(selectedValue)) {
                    this.comboField.select(i);
                    this.value = selectedValue;
                    return;
                }
                ++i;
            }
        }
        if (this.labelsAndValues.length > 0) {
            this.comboField.select(0);
            this.value = this.labelsAndValues[0][1];
        }
    }

    public Combo getComboControl() {
        return this.comboField;
    }

    protected Combo getComboControl(Composite parent) {
        if (this.comboField == null) {
            this.comboField = new Combo(parent, 2124);
            this.comboField.setFont(parent.getFont());
            if (this.labelsAndValues != null) {
                int i = 0;
                while (i < this.labelsAndValues.length) {
                    this.comboField.add(this.labelsAndValues[i][0]);
                    ++i;
                }
            }
            this.comboField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int index = ComboFieldEditor.this.comboField.getSelectionIndex();
                    if (index >= 0) {
                        String oldValue = ComboFieldEditor.this.value;
                        ComboFieldEditor.this.value = ComboFieldEditor.this.labelsAndValues[index][1];
                        ComboFieldEditor.this.setPresentsDefaultValue(false);
                        ComboFieldEditor.this.fireValueChanged("field_editor_value", oldValue, ComboFieldEditor.this.value);
                    }
                }
            });
            this.comboField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ComboFieldEditor.this.comboField = null;
                }
            });
        } else {
            this.checkParent((Control)this.comboField, parent);
        }
        return this.comboField;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getComboControl(parent).setEnabled(enabled);
    }
}

