/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash;

import com.ibm.icu.text.MessageFormat;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.actf.model.flash.ASAccInfo;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashConst;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.model.flash.as.ASObject;
import org.eclipse.actf.model.internal.flash.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASNodeImplV8
implements IFlashConst,
IASNode {
    private static final String LEVEL0_FOCUS_MANAGER = "_level0.focusManager";
    private static final String LEVEL0_RESERVED = "_level0.reserved";
    private IFlashPlayer player;
    private ASObject asObject;
    private IASNode parent;
    private int level;
    private int id;
    private ASAccInfo accInfo;
    private boolean isReference = false;
    private boolean skipChildren = false;
    private boolean isAccProperties = false;
    private Boolean hasOnRelease;
    private String strIconType = "others";
    private String strType;
    private String strClassName;
    private String strObjectName;
    private String strTarget;
    private boolean isUIComponent;

    public ASNodeImplV8(IASNode parent, IFlashPlayer player, ASObject node) {
        this.parent = parent;
        this.level = parent != null ? parent.getLevel() + 1 : 0;
        this.player = player;
        this.asObject = node;
        this.strType = this.getString("type");
        this.strClassName = this.getString("className");
        this.strObjectName = this.getString("objectName");
        this.strTarget = this.getString("target");
        Object tmpId = this.asObject.get("id");
        this.id = tmpId instanceof Integer ? (Integer)tmpId : -1;
        this.isUIComponent = "true".equals(this.getString("isUIComponent"));
        if (parent != null) {
            String parentObjectName;
            String targetParent = parent.getTarget();
            if (targetParent != null && !this.strTarget.equals(String.valueOf(targetParent) + "." + this.strObjectName)) {
                this.isReference = true;
            }
            if ("_accProps".equals(parentObjectName = parent.getObjectName()) || "_accImpl".equals(parentObjectName)) {
                this.isAccProperties = true;
            }
        }
        if ("number".equals(this.strType) || "null".equals(this.strType) || "boolean".equals(this.strType) || "string".equals(this.strType) || "undefined".equals(this.strType)) {
            this.skipChildren = true;
        } else if ("object".equals(this.strType)) {
            if (this.strClassName == null || "Array".equals(this.strClassName)) {
                this.skipChildren = true;
            }
        } else if ("movieclip".equals(this.strType) && (LEVEL0_RESERVED.equals(this.strTarget) || LEVEL0_FOCUS_MANAGER.equals(this.strTarget))) {
            this.skipChildren = true;
        }
        this.accInfo = ASAccInfo.create(this.asObject);
        this.initIconType();
    }

    private void initIconType() {
        if ("movieclip".equals(this.strType)) {
            int accRole;
            this.strIconType = this.strType;
            if (this.accInfo != null && -1 != (accRole = this.accInfo.getRole())) {
                this.strIconType = "accrole_" + accRole;
                return;
            }
            if (this.hasOnRelease()) {
                this.strIconType = "Button";
            }
        } else if ("object".equals(this.strType)) {
            this.strIconType = this.strType;
            if ("Button".equals(this.strClassName)) {
                this.strIconType = "Button";
            } else if (this.strClassName.startsWith("TextField")) {
                this.strIconType = "text";
            } else if ("_accImpl".equals(this.strObjectName) || "_accProps".equals(this.strObjectName)) {
                this.strIconType = "accprops";
            }
        } else if ("function".equals(this.strType) || "string".equals(this.strType)) {
            this.strIconType = this.strType;
        } else if ("number".equals(this.strType) || "null".equals(this.strType) || "boolean".equals(this.strType) || "undefined".equals(this.strType)) {
            this.strIconType = "variable";
        }
    }

    @Override
    public String getType() {
        return this.strType;
    }

    @Override
    public String getClassName() {
        return this.strClassName;
    }

    @Override
    public String getObjectName() {
        return this.strObjectName;
    }

    @Override
    public String getTarget() {
        return this.strTarget;
    }

    @Override
    public boolean isUIComponent() {
        return this.isUIComponent;
    }

    @Override
    public String getValue() {
        if (this.asObject != null) {
            return this.decodeString(this.getString("value"));
        }
        return null;
    }

    @Override
    public String getText() {
        return this.getText(true);
    }

    @Override
    public String getText(boolean useAccName) {
        String text = null;
        if (useAccName && this.accInfo != null) {
            text = this.accInfo.getName();
        }
        if (text == null) {
            if (this.asObject != null) {
                text = this.getString("text");
            }
        } else {
            text = "[" + text + "]";
        }
        return this.decodeString(text);
    }

    @Override
    public String getTitle() {
        if (this.asObject != null) {
            return this.decodeString(this.getString("title"));
        }
        return null;
    }

    private String getString(String name) {
        if (this.asObject != null) {
            Object result = this.asObject.get(name);
            return result == null ? null : result.toString();
        }
        return null;
    }

    private Number getNumber(String name) {
        if (this.asObject != null) {
            Object result = this.asObject.get(name);
            if (result == null) {
                return null;
            }
            if (result instanceof Number) {
                return (Number)result;
            }
            return null;
        }
        return null;
    }

    @Override
    public Object getObject(String name) {
        if (this.asObject != null) {
            return this.asObject.get(name);
        }
        return null;
    }

    private String decodeString(String input) {
        if (input != null) {
            try {
                return URLDecoder.decode(input, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return input;
    }

    private double getDoubleValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return Double.NaN;
    }

    @Override
    public IASNode getParent() {
        return this.parent;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    private boolean shouldSkip() {
        return this.skipChildren && !this.isAccProperties || this.isReference;
    }

    @Override
    public boolean isAccProperties() {
        return this.isAccProperties;
    }

    @Override
    public boolean hasChild(boolean visual) {
        return this.hasChild(visual, false);
    }

    @Override
    public boolean hasChild(boolean visual, boolean debugMode) {
        if (this.level >= 50) {
            throw new Error(String.valueOf(MessageFormat.format((String)Messages.flash_error_target_length, (Object[])new Object[]{new Integer(this.level)})) + "\n" + this.strTarget);
        }
        return this.player.hasChild(this, visual, debugMode);
    }

    @Override
    public IASNode[] getChildren(boolean visual) {
        return this.getChildren(visual, false);
    }

    @Override
    public IASNode[] getEntireChildren() {
        return this.getChildren(false, true);
    }

    private IASNode[] getChildren(boolean visual, boolean debugMode) {
        IASNode[] children = this.player.getChildren(this, visual, debugMode);
        ArrayList<ASNodeImplV8> childList = new ArrayList<ASNodeImplV8>();
        IASNode[] iASNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IASNode child = iASNodeArray[n2];
            if (child instanceof ASNodeImplV8) {
                ASNodeImplV8 node = (ASNodeImplV8)child;
                if (debugMode || visual || !node.shouldSkip()) {
                    childList.add(node);
                }
            }
            ++n2;
        }
        return childList.toArray(new IASNode[childList.size()]);
    }

    @Override
    public boolean setMarker() {
        if (this.asObject != null) {
            try {
                return this.player.setMarker(this.getNumber("x"), this.getNumber("y"), this.getNumber("w"), this.getNumber("h"));
            }
            catch (Exception exception) {}
        }
        return false;
    }

    @Override
    public IFlashPlayer getPlayer() {
        return this.player;
    }

    @Override
    public ASAccInfo getAccInfo() {
        return this.accInfo;
    }

    @Override
    public Set<String> getKeys() {
        if (this.asObject != null) {
            return this.asObject.getKeys();
        }
        return null;
    }

    @Override
    public boolean hasOnRelease() {
        if (this.hasOnRelease == null) {
            IASNode onReleaseNode = this.player.getNodeFromPath(String.valueOf(this.strTarget) + ".onRelease");
            this.hasOnRelease = onReleaseNode != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.hasOnRelease;
    }

    @Override
    public double getX() {
        return this.getDoubleValue(this.asObject.get("x"));
    }

    @Override
    public double getY() {
        return this.getDoubleValue(this.asObject.get("y"));
    }

    @Override
    public double getWidth() {
        return this.getDoubleValue(this.asObject.get("w"));
    }

    @Override
    public double getHeight() {
        return this.getDoubleValue(this.asObject.get("h"));
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getDepth() {
        Integer target = (Integer)this.asObject.get("depth");
        if (target != null) {
            return target;
        }
        return -16384;
    }

    @Override
    public int getCurrentFrame() {
        Integer target = (Integer)this.asObject.get("currentFrame");
        if (target != null) {
            return target;
        }
        return -1;
    }

    @Override
    public boolean isInputable() {
        Boolean b = (Boolean)this.asObject.get("isInputable");
        if (b == null) {
            return false;
        }
        return b;
    }

    @Override
    public boolean isOpaqueObject() {
        Boolean b = (Boolean)this.asObject.get("isOpaqueObject");
        if (b == null) {
            return false;
        }
        return b;
    }

    @Override
    public int getTabIndex() {
        Number num = this.getNumber("tabIndex");
        if (num == null) {
            return -1;
        }
        return num.intValue();
    }

    @Override
    public String getIconType() {
        return this.strIconType;
    }
}

