/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.html;

import org.eclipse.actf.model.dom.dombycom.impl.DocumentImpl;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.FrameNodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.HTMLElementImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.ImageElementImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.SelectElementImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.TextImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.TitleElementImpl;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.w3c.dom.Element;

public class HTMLElementFactory {
    private static final String IFRAME = "iframe";
    private static final String TITLE = "title";
    private static final String IMG = "img";
    private static final String SELECT = "select";
    private static final String TEXT = "text";
    private static final String FRAMENODE = "framenode";

    public static NodeImpl create(NodeImpl base, IDispatch inode, String tagName) {
        String tagNameLower = tagName.toLowerCase();
        try {
            if (tagNameLower.equals(FRAMENODE)) {
                return new FrameNodeImpl(base, inode);
            }
            if (tagNameLower.equals(TEXT)) {
                return new TextImpl(base, inode);
            }
            if (tagNameLower.equals(SELECT)) {
                return new SelectElementImpl(base, inode);
            }
            if (tagNameLower.equals(IMG)) {
                return new ImageElementImpl(base, inode);
            }
            if (tagNameLower.equals(TITLE)) {
                return new TitleElementImpl(base, inode);
            }
            return new HTMLElementImpl(base, inode);
        }
        catch (DispatchException dispatchException) {
            return null;
        }
    }

    public static Element createElement(DocumentImpl base, IDispatch inode, String tagName) {
        IDispatch r;
        block4: {
            try {
                r = (IDispatch)inode.invoke1("createElement", (Object)tagName);
                if (r != null) break block4;
                return null;
            }
            catch (DispatchException dispatchException) {
                return null;
            }
        }
        if (tagName.toLowerCase().equals(IFRAME)) {
            return new FrameNodeImpl((NodeImpl)base, r);
        }
        return new HTMLElementImpl(base, r);
    }
}

