/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.PrintWriter;
import org.eclipse.actf.model.internal.dom.sgml.IPrintXML;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLCharacterData;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Text;

public class SGMLText
extends SGMLCharacterData
implements Text,
IPrintXML {
    private static final long serialVersionUID = -579697061500329505L;
    private boolean isWhitespace = false;

    public SGMLText(String str, Document doc) {
        super(str, doc);
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return "#text";
    }

    public Text splitText(int offset) throws DOMException {
        SGMLText sibling;
        try {
            sibling = new SGMLText(this.text.substring(offset), this.ownerDocument);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new DOMException(1, e.getMessage()){
                private static final long serialVersionUID = -1750553827974411478L;
            };
        }
        sibling.previousSibling = this;
        sibling.parent = this.parent;
        this.nextSibling = sibling;
        this.text = this.text.substring(offset);
        return this;
    }

    public String toString() {
        SGMLDocument doc = (SGMLDocument)this.getOwnerDocument();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.text.length()) {
            char ch = this.text.charAt(i);
            Character C = new Character(ch);
            String entityOrigin = doc.getEntityOrigin(C);
            if (entityOrigin != null) {
                sb.append(String.valueOf('&') + entityOrigin + ';');
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public String toXMLString() {
        SGMLDocument doc = (SGMLDocument)this.getOwnerDocument();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.text.length()) {
            char ch = this.text.charAt(i);
            Character C = new Character(ch);
            String entityOrigin = doc.getEntityOrigin(C);
            if (entityOrigin != null) {
                sb.append("&#" + ch + ';');
            } else if (ch == '&') {
                sb.append("&amp;");
            } else if (ch == '<') {
                sb.append("&lt;");
            } else if (ch == '>') {
                sb.append("&gt;");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public void printAsXML(PrintWriter pw, int indentLevel, boolean indent) {
        pw.print(this.toXMLString());
    }

    public void printAsSGML(PrintWriter pw, int indentLevel, boolean indent) {
        pw.print(this.toString());
    }

    public boolean getIsWhitespaceInElementContent() {
        return this.isWhitespace;
    }

    void setIsWhitespaceInElementContent(boolean b) {
        this.isWhitespace = b;
    }

    public String getWholeText() {
        return null;
    }

    public boolean isElementContentWhitespace() {
        return false;
    }

    public Text replaceWholeText(String content) throws DOMException {
        return null;
    }
}

