/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPConnectionException;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageReader;

public class HTTPRequestReader
extends HTTPMessageReader {
    static final Logger LOGGER = Logger.getLogger(HTTPRequestReader.class);

    public HTTPRequestReader(InputStream in) {
        super(in);
    }

    protected void readFirstLine(HTTPMessage msg, long timeout) throws IOException, TimeoutException {
        IHTTPRequestMessage req = (IHTTPRequestMessage)((Object)msg);
        HTTPMessageBuffer buf = msg.getBuffer();
        this.skipSpaceCRAndLFs(timeout);
        this.readNextToken(timeout, buf, req.getMethod(), ' ');
        if (this.getLastByte() == -1) {
            throw new HTTPConnectionException("Request connection is closed.");
        }
        if (this.getLastByte() != 32) {
            throw new IOException("Unexpected char (expected=SP): " + Integer.toString(this.getLastByte()) + "/" + buf.getAsString(req.getMethod()));
        }
        this.skipSpaces(timeout, buf);
        this.readNextToken(timeout, buf, req.getRequestURI(), ' ');
        if (this.getLastByte() != 32) {
            throw new IOException("Unexpected char (expected=SP): " + Integer.toString(this.getLastByte()));
        }
        this.skipSpaces(timeout, buf);
        this.readNextToken(timeout, buf, req.getHTTPVersion());
        if (this.getLastByte() != 10) {
            throw new IOException("Unexpected char (expected=LF): " + Integer.toString(this.getLastByte()));
        }
    }
}

