/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.IBufferRange;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPHeader;

public class HTTPMessageBuffer
extends ByteArrayOutputStream {
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 1024;

    public HTTPMessageBuffer() {
        super(1024);
    }

    public HTTPMessageBuffer(int initBufferSize) {
        super(initBufferSize);
    }

    protected HTTPMessageBuffer(byte[] body) {
        this.buf = body;
        this.count = body.length;
    }

    public byte[] getByteArray() {
        return this.buf;
    }

    public final int getLength() {
        return this.count;
    }

    public String getAsString(IBufferRange range) {
        return new String(this.buf, range.getStart(), range.getLength());
    }

    public byte[] getAsBytes(IBufferRange range) {
        int len = range.getLength();
        if (len <= 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[len];
        System.arraycopy(this.buf, range.getStart(), bytes, 0, len);
        return bytes;
    }

    public final void writeTo(OutputStream out, IBufferRange range) throws IOException {
        out.write(this.buf, range.getStart(), range.getLength());
    }

    public boolean equals(IBufferRange range, byte[] data) {
        int len = data.length;
        if (len != range.getLength()) {
            return false;
        }
        int offset = range.getStart();
        byte[] buffer = this.buf;
        int i = len - 1;
        while (i >= 0) {
            if (data[i] != buffer[offset + i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    public boolean equalsIgnoreCase(IBufferRange range, byte[] data) {
        int len = data.length;
        if (len != range.getLength()) {
            return false;
        }
        int offset = range.getStart();
        byte[] buffer = this.buf;
        int i = len - 1;
        while (i >= 0) {
            if (HTTPHeader.toUpcase(data[i]) != HTTPHeader.toUpcase(buffer[offset + i])) {
                return false;
            }
            --i;
        }
        return true;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }
}

