/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPMessage;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkedMessageBodyReader;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.HeaderInBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.HeaderToAdd;
import org.eclipse.actf.util.internal.httpproxy.core.MessageBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPMessage
implements IHTTPMessage {
    static final Logger LOGGER = Logger.getLogger(HTTPMessage.class);
    private transient long fSerial;
    private HTTPMessageBuffer fBuffer;
    private IMessageBody fOriginalMessageBody;
    private IMessageBody fTransformedMessageBody = null;
    private List<IHTTPHeader> fHeaders = new ArrayList<IHTTPHeader>(50);
    private List<IHTTPHeader> fTrailingHeaders;
    private boolean isChunkedEncoding = false;
    private long fTid = 0L;
    private static final byte[] CLOSE_A = "close".getBytes();
    private static final byte[] KEEP_ALIVE_A = "Keep-Alive".getBytes();

    public HTTPMessage(long serial) {
        this(serial, 1024);
    }

    public HTTPMessage(long serial, int initBufferSize) {
        this.fSerial = serial;
        this.fBuffer = new HTTPMessageBuffer(initBufferSize);
        this.fOriginalMessageBody = null;
    }

    protected HTTPMessage(long serial, byte[] body) {
        this.fSerial = serial;
        this.fBuffer = new HTTPMessageBuffer();
        this.setOriginalMessageBody(new MessageBody(new ByteArrayInputStream(body), body.length));
    }

    @Override
    public long getSerial() {
        return this.fSerial;
    }

    @Override
    public abstract String getHTTPVersionAsString();

    @Override
    public abstract byte[] getHTTPVersionAsBytes();

    protected abstract boolean isBodyEmpty();

    final void setOriginalMessageBody(IMessageBody msgBody) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("setOriginalMessageBody: " + msgBody);
        }
        this.updateContentLengthHeader(msgBody);
        this.fOriginalMessageBody = msgBody;
    }

    final void updateContentLengthHeader(IMessageBody msgBody) {
        int contentLength;
        int oldContentLength = this.fOriginalMessageBody == null ? -1 : this.fOriginalMessageBody.getContentLength();
        int n = contentLength = msgBody == null ? -1 : msgBody.getContentLength();
        if (contentLength >= 0) {
            this.setHeader(IHTTPHeader.CONTENT_LENGTH_A, Integer.toString(contentLength).getBytes());
        } else if (oldContentLength >= 0) {
            this.removeHeader(IHTTPHeader.CONTENT_LENGTH_A);
        }
    }

    protected IMessageBody getOriginalMessageBody() {
        return this.fOriginalMessageBody;
    }

    protected IMessageBody getTransformedMessageBody() {
        return this.fTransformedMessageBody;
    }

    @Override
    public IMessageBody getMessageBody() {
        return this.fTransformedMessageBody != null ? this.fTransformedMessageBody : this.fOriginalMessageBody;
    }

    protected abstract void writeFirstLine(OutputStream var1) throws IOException;

    protected HTTPMessageBuffer getBuffer() {
        return this.fBuffer;
    }

    @Override
    public final List<IHTTPHeader> getHeaders() {
        return this.fHeaders;
    }

    @Override
    public final IHTTPHeader removeHeader(byte[] name) {
        for (IHTTPHeader h : this.fHeaders) {
            if (h.isRemoved() || !h.isFieldNameEqualsTo(name)) continue;
            h.setRemoved(true);
            return h;
        }
        return null;
    }

    @Override
    public final void setHeader(byte[] name, byte[] value) {
        HeaderToAdd header = new HeaderToAdd();
        header.init(name, value);
        this.removeHeader(name);
        this.fHeaders.add(header);
    }

    final void addHeader(HeaderInBuffer header) {
        this.fHeaders.add(header);
    }

    @Override
    public final void addTrailingHeader(IHTTPHeader trailer) {
        if (this.fTrailingHeaders == null) {
            this.fTrailingHeaders = new ArrayList<IHTTPHeader>(50);
        }
        this.fTrailingHeaders.add(trailer);
    }

    @Override
    public final IHTTPHeader getHeader(byte[] name) {
        for (IHTTPHeader header : this.fHeaders) {
            if (!header.isFieldNameEqualsTo(name)) continue;
            return header;
        }
        return null;
    }

    @Override
    public final byte[] getHeaderAsBytes(byte[] name) {
        IHTTPHeader header = this.getHeader(name);
        return header == null ? null : header.getValue();
    }

    @Override
    public final boolean isChunkedEncoding() {
        return this.isChunkedEncoding;
    }

    @Override
    public final void setChunkedEncoding(boolean isChunked) {
        this.isChunkedEncoding = isChunked;
    }

    @Override
    public final void setTid(long tid) {
        this.fTid = tid;
    }

    @Override
    public long getTid() {
        return this.fTid;
    }

    protected void writeHeaders(OutputStream out) throws IOException {
        this.writeFirstLine(out);
        for (IHTTPHeader header : this.fHeaders) {
            header.writeLine(out);
        }
        out.write(13);
        out.write(10);
    }

    protected abstract void writeBodyWithoutContentLength(long var1, IMessageBody var3, OutputStream var4) throws IOException, TimeoutException;

    @Override
    public void writeBody(long timeout, IMessageBody msgBody, OutputStream out) throws IOException, TimeoutException {
        if (msgBody == null) {
            return;
        }
        InputStream body = msgBody.getMessageBodyInputStream();
        int contentLength = msgBody.getContentLength();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("super.writeBody: contentLength=" + contentLength + ", body=" + body + ", isChunkedEncoding=" + msgBody.isChunkedEncoding());
        }
        if (body != null) {
            if (contentLength >= 0) {
                int i = 0;
                while (i < contentLength) {
                    int b = body.read();
                    if (b < 0) {
                        LOGGER.debug("Unexpected connection shutdown...:" + i + ":" + body);
                    }
                    out.write(b);
                    ++i;
                }
            } else if (msgBody.isChunkedEncoding()) {
                ChunkedMessageBodyReader chunkReader = new ChunkedMessageBodyReader(body);
                chunkReader.readChunkedMessage(timeout, out, this);
            } else {
                this.writeBodyWithoutContentLength(timeout, msgBody, out);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("super.writeBody: done");
        }
    }

    protected IMessageBody transformMessageBody(long timeout, IMessageBody src) throws IOException, TimeoutException {
        return null;
    }

    @Override
    public void write(long timeout, OutputStream out) throws IOException, TimeoutException {
        if (this.fTransformedMessageBody == null) {
            this.fTransformedMessageBody = this.transformMessageBody(timeout, this.fOriginalMessageBody);
            if (this.fTransformedMessageBody != null) {
                this.updateContentLengthHeader(this.fTransformedMessageBody);
            }
        }
        this.writeHeaders(out);
        this.writeBody(timeout, this.getMessageBody(), out);
    }

    @Override
    public boolean isHTTPVersion1_1() {
        return Arrays.equals(IHTTPHeader.HTTP_VERSION_1_1_A, this.getHTTPVersionAsBytes());
    }

    @Override
    public void setConnectionHeader(boolean keepalive) {
        if (keepalive) {
            this.setHeader(IHTTPHeader.CONNECTION_A, KEEP_ALIVE_A);
        } else {
            this.setHeader(IHTTPHeader.CONNECTION_A, CLOSE_A);
        }
    }

    @Override
    public boolean isConnectionToBeClosed() {
        IHTTPHeader h = this.getHeader(IHTTPHeader.CONNECTION_A);
        if (this.isHTTPVersion1_1()) {
            if (h == null) {
                return false;
            }
            return h.compareValueIgnoreCase(CLOSE_A);
        }
        if (h == null) {
            return true;
        }
        return !h.compareValueIgnoreCase(KEEP_ALIVE_A);
    }

    public String toString() {
        return "HTTPMessage " + this.fSerial + ":" + this.fBuffer.toString();
    }
}

