/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.scripteditor.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.actf.ai.internal.ui.scripteditor.XMLFileMessageBox;
import org.eclipse.actf.ai.scripteditor.data.ScriptData;
import org.eclipse.actf.ai.scripteditor.util.VoicePlayerFactory;
import org.eclipse.actf.util.FileUtils;

public class TTMLUtil {
    private static ScriptData instScriptData = ScriptData.getInstance();

    public static void exportTTML(String ttmlPathname, boolean warnOverwrite) {
        TTMLUtil.exportTTML(ttmlPathname, false, null, null, null, warnOverwrite);
    }

    public static void exportTTMLandWAV(String ttmlPathname, String adWavDirpath, String adWavFilename, String adUrlBase, boolean warnOverwrite) {
        TTMLUtil.exportTTML(ttmlPathname, true, adWavDirpath, adWavFilename, adUrlBase, warnOverwrite);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void exportTTML(String ttmlPathname, boolean isPrerecorded, String adWavDirpath, String adWavFilename, String adUrlBase, boolean warnOverwrite) {
        File file;
        VoicePlayerFactory voice;
        PrintWriter writer;
        block25: {
            XMLFileMessageBox warningExistFile;
            int ret;
            writer = null;
            voice = VoicePlayerFactory.getInstance();
            file = new File(ttmlPathname);
            if (!warnOverwrite || !file.exists() || (ret = (warningExistFile = new XMLFileMessageBox(2, ttmlPathname)).open()) == 64) break block25;
            if (writer == null) return;
            try {
                writer.flush();
                writer.close();
                return;
            }
            catch (Exception exception) {}
            return;
        }
        try {
            try {
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ttmlPathname), "UTF-8"));
                String LINE_SEP = FileUtils.LINE_SEP;
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<?xml-stylesheet href=\"ttml.css\" type=\"text/css\"?>");
                writer.println("<?access-control allow=\"*\"?>");
                writer.println("<tt ttp:profile='http://www.w3.org/ns/ttml/profile/dfxp-full'" + LINE_SEP + "    xmlns='http://www.w3.org/ns/ttml'" + LINE_SEP + "    xmlns:ttm='http://www.w3.org/ns/ttml#metadata'" + LINE_SEP + "    xmlns:tts='http://www.w3.org/ns/ttml#styling'" + LINE_SEP + "    xmlns:ttp='http://www.w3.org/ns/ttml#parameter'" + LINE_SEP + "    xmlns:tvd='http://www.eclipse.org/actf/ai/tvd'>");
                writer.println(" <head>");
                writer.println("  <metadata>");
                writer.println("   <ttm:title>TextTrack (Audio Description)</ttm:title>");
                writer.println("  </metadata>");
                writer.println("  <styling>" + LINE_SEP + "   <style xml:id=\"style1\"/>" + LINE_SEP + "  </styling>" + LINE_SEP + "  <layout>" + LINE_SEP + "   <region xml:id=\"region1\" style=\"style1\"/>" + LINE_SEP + "  </layout>" + LINE_SEP + " </head>" + LINE_SEP + " <body>" + LINE_SEP + "  <div role=\"narration\" region=\"region1\">");
                if (isPrerecorded) {
                    File readmeFile = new File(String.valueOf(adWavDirpath) + "1st_Readme.txt");
                    try {
                        PrintWriter pw = new PrintWriter(readmeFile, "UTF-8");
                        if (voice.canSpeakToFile()) {
                            pw.println("Please convert wav files into wma/oga/m4a formats.");
                            pw.println(" wma: for IE8 or older");
                            pw.println(" oga: for Chrome, Firefox, Opera");
                            pw.println(" m4a: for IE9 or later, Safari");
                            pw.println();
                            pw.println("After converting files, please deploy these files to your Web server,");
                            pw.println("and adjust URLs of \"tvd:external\" attribute in " + file.getName());
                            pw.flush();
                            pw.close();
                        } else {
                            pw.println("This TTS engine can't create wav files.");
                            pw.println("Please prepare audio descriptions in wma/oga/m4a formats.");
                            pw.println(" wma: for IE8 or older");
                            pw.println(" oga: for Chrome, Firefox, Opera");
                            pw.println(" m4a: for IE9 or later, Safari");
                            pw.println();
                            pw.println("After preparing files, please deploy these files to your Web server,");
                            pw.println("and adjust URLs of \"tvd:external\" attribute in " + file.getName());
                            pw.flush();
                            pw.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                int i = 0;
                while (i < instScriptData.getLengthScriptList()) {
                    int startTime = instScriptData.getScriptStartTime(i);
                    int frame = startTime % 1000 / 33;
                    String frameS = frame > 9 ? Integer.toString(frame) : "0" + frame;
                    String strStartTime = String.valueOf(instScriptData.makeFormatHHMMSS(startTime / 1000)) + ":" + frameS;
                    int endTime = instScriptData.getScriptEndTime(i);
                    int duration = endTime - startTime;
                    frame = endTime % 1000 / 33;
                    frameS = frame > 9 ? Integer.toString(frame) : "0" + frame;
                    String StrEndTime = String.valueOf(instScriptData.makeFormatHHMMSS(endTime / 1000)) + ":" + frameS;
                    frame = duration % 1000 / 33;
                    frameS = frame > 9 ? Integer.toString(frame) : "0" + frame;
                    String strDuration = String.valueOf(instScriptData.makeFormatHHMMSS(duration / 1000)) + ":" + frameS;
                    String strDesc = instScriptData.getScriptData(i);
                    writer.print("    <p xml:id=\"description" + i + "\" begin=\"" + strStartTime);
                    if (instScriptData.getExtendExtended(i).booleanValue()) {
                        writer.print("\" tvd:extended=\"true\" dur=\"" + strDuration + "\"");
                    } else {
                        writer.print("\" tvd:extended=\"false\" end=\"" + StrEndTime + "\"");
                    }
                    if (isPrerecorded) {
                        int number = i + 1;
                        String ad_file = number < 10 ? String.valueOf(adWavFilename) + "_0000" + number : (number < 100 ? String.valueOf(adWavFilename) + "_000" + number : (number < 1000 ? String.valueOf(adWavFilename) + "_00" + number : (number < 10000 ? String.valueOf(adWavFilename) + "_0" + number : String.valueOf(adWavFilename) + number)));
                        if (adUrlBase == null || adUrlBase.isEmpty()) {
                            writer.print(" tvd:external=\"file://" + adWavDirpath + ad_file + ".*\"");
                        } else {
                            writer.print(" tvd:external=\"" + adUrlBase + ad_file + ".*\"");
                        }
                        if (voice.canSpeakToFile()) {
                            String strGender = instScriptData.getExtendGender(i) != false ? "male" : "female";
                            voice.setGender(strGender);
                            voice.setSpeed(instScriptData.getExtendSpeed(i));
                            voice.speakToFile(instScriptData.getScriptData(i), new File(String.valueOf(adWavDirpath) + ad_file + ".wav"));
                        }
                    }
                    writer.println(">" + TTMLUtil.canonicalize(strDesc) + "</p>");
                    ++i;
                }
                writer.println("  </div>" + LINE_SEP + " </body>" + LINE_SEP + "</tt>");
            }
            catch (IOException e) {
                e.printStackTrace();
                if (writer == null) return;
                try {
                    writer.flush();
                    writer.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            if (writer == null) throw throwable;
            try {
                writer.flush();
                writer.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        if (writer == null) return;
        try {
            writer.flush();
            writer.close();
            return;
        }
        catch (Exception exception) {}
    }

    private static String canonicalize(String targetS) {
        return targetS.replaceAll("\\p{Cntrl}", "").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }
}

