/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.scripteditor.util;

import org.eclipse.actf.ai.internal.ui.scripteditor.EditPanelTab;
import org.eclipse.actf.ai.internal.ui.scripteditor.PreviewPanel;
import org.eclipse.actf.ai.internal.ui.scripteditor.XMLFileMessageBox;
import org.eclipse.actf.ai.scripteditor.data.ScriptData;
import org.eclipse.actf.ai.scripteditor.data.XMLFileSaveUtil;
import org.eclipse.actf.ai.scripteditor.reader.CSVReader;
import org.eclipse.actf.ai.scripteditor.reader.SAXReader;
import org.eclipse.actf.ai.ui.scripteditor.views.EditPanelView;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.ai.ui.scripteditor.views.ScriptListView;
import org.eclipse.actf.ai.ui.scripteditor.views.TimeLineView;

public class DragDropFileReader
implements IUNIT {
    private ScriptData instScriptData = null;
    private EditPanelTab instEditPanelTab = null;
    private TimeLineView instTimeLine = null;
    private PreviewPanel instPreviewPanel = null;
    private ScriptListView instScriptList = null;
    private int modeFile = 0;
    private String saveFileName = "";
    private String currentURLMovie = "about:blank";

    public DragDropFileReader(int mode, String fname) {
        this.modeFile = mode;
        this.saveFileName = fname;
        this.pickupInstViewPart();
    }

    public void load() {
        if (this.modeFile == 0) {
            this.loadXMLFile();
        } else if (this.modeFile == 1) {
            this.loadCSVFile();
        }
    }

    private void pickupInstViewPart() {
        if (this.instEditPanelTab == null) {
            this.instEditPanelTab = EditPanelView.getInstance().getInstanceTabEditPanel();
        }
        if (this.instTimeLine == null) {
            this.instTimeLine = TimeLineView.getInstance();
        }
        if (this.instPreviewPanel == null) {
            this.instPreviewPanel = PreviewPanel.getInstance();
        }
        if (this.instScriptList == null) {
            this.instScriptList = ScriptListView.getInstance();
        }
        if (this.instScriptData == null) {
            this.instScriptData = ScriptData.getInstance();
        }
    }

    private void preProcessLoadFile() {
        this.instScriptData.clearScriptData();
        this.instTimeLine.reqStoreVolLvlFilePath(null);
    }

    private void postProcessLoadFile() {
        this.instScriptList.getInstScriptList().reloadScriptList();
        this.instEditPanelTab.initDispEditPanel();
        EditPanelView.getInstance().getInstanceTabSelWAVFile().initDescriptionStruct();
        EditPanelView.getInstance().getInstanceTabSelWAVFile().initDispSelWavFile();
        this.instPreviewPanel.setURLMovie(this.currentURLMovie);
        this.instTimeLine.reqStoreXMLFilePath(this.saveFileName);
        this.instTimeLine.reqExpandTimeLine();
        this.instTimeLine.reqRedrawTimeLineCanvas(1);
        this.instTimeLine.reqLoadVolumeLevelData();
        this.instTimeLine.reqRedrawVolumeLevelCanvas(2);
        this.instTimeLine.refreshScriptAudio();
        this.instTimeLine.rewindActionTimeLine();
    }

    private void loadFile(String fname) {
        SAXReader loader = null;
        try {
            try {
                loader = new SAXReader();
                loader.startSAXReader(fname, this.instEditPanelTab);
                this.currentURLMovie = loader.getUri();
            }
            catch (Exception e) {
                System.out.println("loadFile() : Exception = " + e);
                loader = null;
            }
        }
        finally {
            loader = null;
        }
    }

    private void loadXMLFile() {
        boolean start_flg = true;
        if (this.instScriptData.getStatusSaveScripts() > 0) {
            XMLFileMessageBox confModifyMB = new XMLFileMessageBox(5, null);
            int result = confModifyMB.open();
            if (result == 64) {
                XMLFileSaveUtil saveFH = new XMLFileSaveUtil();
                String filePath = saveFH.open();
                saveFH.save(filePath, true);
            } else if (result == 256) {
                start_flg = false;
            }
        }
        if (start_flg && this.saveFileName != null) {
            this.preProcessLoadFile();
            this.loadFile(this.saveFileName);
            this.postProcessLoadFile();
        }
    }

    private void loadCSVFile() {
        boolean start_flg = true;
        if (this.instScriptData.getStatusSaveScripts() > 0) {
            XMLFileMessageBox confModifyMB = new XMLFileMessageBox(5, null);
            int result = confModifyMB.open();
            if (result == 64) {
                XMLFileSaveUtil saveFH = new XMLFileSaveUtil();
                String filePath = saveFH.open();
                saveFH.save(filePath, true);
            } else if (result == 256) {
                start_flg = false;
            }
        }
        if (start_flg && this.saveFileName != null) {
            TimeLineView.getInstance().reqStoreXMLFilePath(null);
            CSVReader csvReader = new CSVReader();
            csvReader.startCSVReader(this.saveFileName);
        }
    }
}

