/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.parser;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.model.dom.html.IHTMLParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.dom.html.dochandler.PREHandler;
import org.eclipse.actf.model.dom.html.errorhandler.FramesetErrorHandler;
import org.eclipse.actf.model.dom.html.errorhandler.HTMLErrorHandler;
import org.eclipse.actf.model.internal.dom.html.impl.SHDOMImpl;
import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.parser.CharsetHandler;
import org.eclipse.actf.model.internal.dom.html.parser.EncodingException;
import org.eclipse.actf.model.internal.dom.html.util.JapaneseEncodingDetector;
import org.eclipse.actf.model.internal.dom.html.util.RereadableInputStream;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDOMImplementation;
import org.w3c.dom.html.HTMLDocument;
import org.xml.sax.SAXException;

public class HTMLParser
extends SGMLParser
implements IHTMLParser {
    public RereadableInputStream ris;
    public InputStreamReader isReader;
    public String encoding = null;

    static {
        InputStream inputStream = null;
        inputStream = HTMLParser.class.getResourceAsStream("public_entities.properties");
        if (inputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = string.replace('@', ' ');
                    pubEntityMap.put(string2, (String)properties.get(string));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    InputStreamReader getISReader() {
        return this.isReader;
    }

    public HTMLParser() {
        this.defaultDTD = "-//W3C//DTD HTML 4.0 Transitional//EN";
        this.addErrorHandler(new FramesetErrorHandler());
        this.addErrorHandler(new HTMLErrorHandler());
        this.setDocumentHandler(new PREHandler(this));
        this.setDOMImplementation(SHDOMImpl.getDOMImplementation());
        if (this.getDOMImplementation() == null) {
            this.setDocument(new SHDocument());
        }
    }

    protected Reader getResource(String string) throws IOException {
        InputStream inputStream = IHTMLParser.class.getResourceAsStream("dtd/" + string);
        if (inputStream != null) {
            return new InputStreamReader(inputStream);
        }
        return super.getResource(string);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = null;
        int n = stringArray.length;
        String string2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = -1;
        boolean bl4 = false;
        boolean bl5 = false;
        String string3 = null;
        boolean bl6 = false;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].equals("-d")) {
                bl = true;
                --n;
            } else if (stringArray[n3].equals("-o")) {
                string = stringArray[++n3];
                n -= 2;
            } else if (stringArray[n3].equals("-e")) {
                if (++n3 == stringArray.length) {
                    HTMLParser.usage();
                }
                string2 = stringArray[n3];
                n -= 2;
            } else if (stringArray[n3].equals("-c")) {
                bl2 = true;
                --n;
            } else if (stringArray[n3].equals("-x")) {
                bl5 = true;
                --n;
            } else if (stringArray[n3].equals("-i")) {
                bl3 = true;
                --n;
            } else if (stringArray[n3].startsWith("-w")) {
                if (stringArray[n3].length() == 2) {
                    n2 = 0;
                } else {
                    try {
                        n2 = Integer.parseInt(stringArray[n3].substring(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        HTMLParser.usage();
                    }
                }
                --n;
            } else if (stringArray[n3].startsWith("-ku")) {
                bl6 = true;
                --n;
            } else if (stringArray[n3].equals("-physical")) {
                bl4 = true;
                --n;
            } else {
                if (!stringArray[n3].startsWith("-l") || stringArray[n3].length() <= 2) break;
                string3 = stringArray[n3].substring(2);
                --n;
            }
            ++n3;
        }
        if (n == 0) {
            HTMLParser.usage();
        }
        int n4 = stringArray.length - n;
        while (n4 < stringArray.length) {
            try {
                InputStream inputStream;
                Object object;
                HTMLParser hTMLParser = new HTMLParser();
                hTMLParser.keepUnknownElements(bl6);
                if (n2 != -1) {
                    if (n2 == 0) {
                        hTMLParser.addErrorLogListener(new IErrorLogListener(){

                            public void errorLog(int n, String string) {
                                System.err.println(string);
                            }
                        });
                    } else {
                        final int n5 = n2;
                        hTMLParser.addErrorLogListener(new IErrorLogListener(){

                            public void errorLog(int n, String string) {
                                if (n == n5) {
                                    System.err.println(string);
                                }
                            }
                        });
                    }
                }
                if (bl4) {
                    hTMLParser.elementHandle(false);
                }
                if (bl5) {
                    hTMLParser.setDefaultTagCase(1);
                    hTMLParser.setTagCase(1);
                    hTMLParser.setAttrNameCase(1);
                }
                if (stringArray[n4].equals("-u")) {
                    object = new URL(stringArray[++n4]);
                    inputStream = ((URL)object).openStream();
                } else {
                    inputStream = new FileInputStream(stringArray[n4]);
                }
                System.err.println("parsing " + stringArray[n4] + " ...");
                try {
                    if (bl2) {
                        hTMLParser.parseSwitchEnc(inputStream, string2);
                        System.out.println("Encoding: " + hTMLParser.getEncoding());
                    } else {
                        hTMLParser.parse(inputStream, string2);
                    }
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
                hTMLParser.close();
                if (bl) {
                    OutputStream outputStream = string == null ? System.out : new FileOutputStream(string);
                    object = string2 != null ? new PrintWriter(new OutputStreamWriter(outputStream, string2)) : new PrintWriter(outputStream);
                    if (!bl5) {
                        ((SHDocument)hTMLParser.getDocument()).printAsSGML((PrintWriter)object, bl3);
                    } else {
                        ((SHDocument)hTMLParser.getDocument()).printAsXHTML((PrintWriter)object, bl3, string2);
                    }
                } else if (string3 != null) {
                    object = hTMLParser.getDocument().getElementsByTagName(string3);
                    n4 = 0;
                    while (n4 < object.getLength()) {
                        System.out.println(object.item(n4));
                        ++n4;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ++n4;
        }
    }

    /*
     * Loose catch block
     */
    public Node parse(InputStream inputStream) throws ParseException, IOException, SAXException {
        JapaneseEncodingDetector japaneseEncodingDetector = new JapaneseEncodingDetector(inputStream);
        try {
            this.encoding = japaneseEncodingDetector.detect();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        Node node = this.parse(japaneseEncodingDetector.getInputStream(), this.encoding);
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        return node;
        catch (Exception exception) {
            Node node2;
            try {
                this.isReader = new InputStreamReader(japaneseEncodingDetector.getInputStream());
                node2 = this.parse(this.isReader);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (Exception exception3) {}
            return node2;
        }
    }

    public Node parse(InputStream inputStream, String string) throws SAXException, ParseException, IOException {
        if (string == null) {
            this.isReader = new InputStreamReader(inputStream);
        } else {
            this.encoding = string;
            this.isReader = new InputStreamReader(inputStream, string);
        }
        Node node = this.parse(this.isReader);
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        return node;
    }

    public Node parseSwitchEnc(InputStream inputStream) throws ParseException, IOException, SAXException {
        return this.parseSwitchEnc(inputStream, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node parseSwitchEnc(InputStream inputStream, String string) throws SAXException, ParseException, IOException {
        Node node;
        block14: {
            Node node2;
            this.ris = new RereadableInputStream(inputStream);
            this.setDocumentHandler(new CharsetHandler(this, this.ris));
            try {
                if (string == null) {
                    this.isReader = new InputStreamReader(this.ris);
                } else {
                    this.encoding = string;
                    this.isReader = new InputStreamReader((InputStream)this.ris, string);
                }
                node2 = this.parse(this.isReader);
            }
            catch (EncodingException encodingException) {
                try {
                    if (this.setDOMImplementation(this.getDOMImplementation()) == null) {
                        Document document = this.getDocument();
                        while (document.hasChildNodes()) {
                            document.removeChild(document.getFirstChild());
                        }
                    }
                    this.init();
                    this.encoding = encodingException.getNewReader().getEncoding();
                    node = this.parse(encodingException.getNewReader());
                    break block14;
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
            try {
                inputStream.close();
                return node2;
            }
            catch (Exception exception) {}
            return node2;
        }
        try {
            inputStream.close();
            return node;
        }
        catch (Exception exception) {}
        return node;
    }

    protected Document createDocument(DocumentType documentType) {
        DOMImplementation dOMImplementation = this.getDOMImplementation();
        try {
            if (!(dOMImplementation instanceof HTMLDOMImplementation)) {
                return super.createDocument(documentType);
            }
        }
        catch (Error error) {
            return super.createDocument(documentType);
        }
        HTMLDocument hTMLDocument = ((HTMLDOMImplementation)dOMImplementation).createHTMLDocument("dummy");
        if (hTMLDocument.getDocumentElement() != null) {
            hTMLDocument.removeChild(hTMLDocument.getDocumentElement());
        }
        if (documentType != null) {
            try {
                hTMLDocument.insertBefore(documentType, null);
            }
            catch (DOMException dOMException) {}
        }
        return hTMLDocument;
    }

    public String getEncoding() {
        return this.encoding;
    }

    void setEncoding(String string) {
        this.encoding = string;
    }

    private static void usage() {
        System.out.println("usage java org.eclipse.actf.model.dom.html.parser.HTMLParser [-w[#]] [-d] [-e encoding] [-c] files...");
        System.exit(1);
    }

    protected String getDefaultTopElement() {
        return "HTML";
    }
}

