/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.scripteditor.preferences;

import org.eclipse.actf.ai.internal.ui.scripteditor.Messages;
import org.eclipse.actf.ai.internal.ui.scripteditor.VolumeLevelCanvas;
import org.eclipse.actf.ai.scripteditor.preferences.CapturePreferenceUtil;
import org.eclipse.actf.ai.scripteditor.util.SoundMixer;
import org.eclipse.actf.examples.scripteditor.Activator;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.ScaleFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CapturePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ScaleFieldEditor gainEditor = null;
    private Label gainLabel = null;
    private CaptureAudioPropertyChangeListener chgListener = null;

    public CapturePreferencePage() {
        super(1);
        this.setDescription(Messages.capture_description);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.chgListener = new CaptureAudioPropertyChangeListener();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.chgListener);
    }

    protected void createFieldEditors() {
        String[][] labelAndValue = new String[][]{{Messages.capture_samprate_fast, "SAMPRATE_FAST"}, {Messages.capture_samprate_nom, "SAMPRATE_NOM"}, {Messages.capture_samprate_late, "SAMPRATE_LATE"}};
        this.addField((FieldEditor)new RadioGroupFieldEditor("CaptureSamplingRate", Messages.capture_samprate_title, 1, labelAndValue, this.getFieldEditorParent()));
        this.gainEditor = new ScaleFieldEditor("GainVolumeLevel", Messages.capture_vollvl_gain, this.getFieldEditorParent(), 50, 500, 5, 25);
        this.addField((FieldEditor)this.gainEditor);
        Composite compo = new Composite(this.getFieldEditorParent(), 0);
        GridLayout layoutCompo = new GridLayout();
        layoutCompo.marginHeight = 0;
        layoutCompo.marginWidth = 10;
        compo.setLayout((Layout)layoutCompo);
        GridData layoutDataLabel = new GridData(128);
        layoutDataLabel.horizontalSpan = 2;
        compo.setLayoutData((Object)layoutDataLabel);
        this.gainLabel = new Label(compo, 0);
        this.gainLabel.setSize(80, 24);
        this.gainLabel.setText(this.makeupGainSliderValue(CapturePreferenceUtil.getPreferenceVolLvlGain()));
        compo.layout();
        compo.pack();
        this.initializeDefaultPreferences();
    }

    public void dispose() {
        super.dispose();
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.chgListener);
        this.gainLabel.dispose();
        this.gainEditor.dispose();
        this.chgListener = null;
        this.gainLabel = null;
        this.gainEditor = null;
    }

    public void init(IWorkbench workbench) {
    }

    private String makeupGainSliderValue(int newValue) {
        String strMeter = String.valueOf(String.valueOf(newValue)) + "%";
        return strMeter;
    }

    private void initializeDefaultPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault("CaptureSamplingRate", "SAMPRATE_NOM");
        store.setDefault("GainVolumeLevel", 100);
    }

    private class CaptureAudioPropertyChangeListener
    implements IPropertyChangeListener {
        private CaptureAudioPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent eve) {
            if ("GainVolumeLevel".equals(eve.getProperty())) {
                int newValue = CapturePreferenceUtil.getPreferenceVolLvlGain();
                VolumeLevelCanvas.getInstance().setCurrentVolLvlGain(newValue);
                CapturePreferencePage.this.gainLabel.setText(CapturePreferencePage.this.makeupGainSliderValue(newValue));
            }
            if ("CaptureSamplingRate".equals(eve.getProperty())) {
                SoundMixer.getInstance().setSampleRateCaptureAudio(CapturePreferenceUtil.getPreferenceSampleRate());
            }
        }
    }
}

