/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.internal.ui.scripteditor;

import org.eclipse.actf.ai.internal.ui.scripteditor.TimeLineCanvas;
import org.eclipse.actf.ai.internal.ui.scripteditor.VolumeLevelCanvas;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.EventManager;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.MouseDragEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.MouseDragEventListener;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.PlayerControlEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.PlayerControlEventListener;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEventListener;
import org.eclipse.actf.ai.scripteditor.data.ScriptData;
import org.eclipse.actf.ai.scripteditor.util.SoundMixer;
import org.eclipse.actf.ai.scripteditor.util.WebBrowserFactory;
import org.eclipse.actf.ai.ui.scripteditor.views.EditPanelView;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.ai.ui.scripteditor.views.TimeLineView;
import org.eclipse.actf.examples.scripteditor.Activator;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.editors.ie.WebBrowserEditor;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Slider;

public class PreviewPanel
implements IUNIT,
SyncTimeEventListener,
MouseDragEventListener,
PlayerControlEventListener {
    private static TimeLineView instParentView = null;
    private static PreviewPanel ownInst = null;
    private static ScriptData instScriptData = null;
    private int currentActionStatus = 0;
    private boolean currentSamplingAudioMode = false;
    private boolean currentStatusMedia = true;
    private boolean currentDragStatus = false;
    private int saveCurrentActionStatus = this.currentActionStatus;
    private Button buttonRewind;
    private Button buttonPlay;
    private Slider sliderPreview;
    private int previousEventSliderPreview = 0;
    private int previousMaxSlider = 0;
    private boolean stopExpandMaxSlider = false;
    private int storeCurrentTimeLineSlider = 0;
    private Label timelinePreview;
    private static EventManager eventManager = null;

    private PreviewPanel() {
        instScriptData = ScriptData.getInstance();
        instParentView = TimeLineView.getInstance();
        eventManager = EventManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PreviewPanel getInstance() {
        if (ownInst != null) return ownInst;
        Class<PreviewPanel> clazz = PreviewPanel.class;
        synchronized (PreviewPanel.class) {
            if (ownInst != null) return ownInst;
            ownInst = new PreviewPanel();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ownInst;
        }
    }

    public void initPreviewPanel(Display parentDisp, Composite parentComposite) {
        try {
            FormData buttonRewindLData = new FormData();
            buttonRewindLData.width = 25;
            buttonRewindLData.height = 23;
            buttonRewindLData.left = new FormAttachment(0, 1000, 4);
            buttonRewindLData.top = new FormAttachment(0, 1000, 2);
            this.buttonRewind = new Button(parentComposite, 0x1000008);
            this.buttonRewind.setLayoutData((Object)buttonRewindLData);
            Image imgRewind = Activator.getImageDescriptor("/icons/Rewind.jpg").createImage();
            this.buttonRewind.setImage(imgRewind);
            this.buttonRewind.setToolTipText("Rewind movie");
            this.buttonRewind.addSelectionListener((SelectionListener)new RewindButtonAdapter());
            this.buttonRewind.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            FormData buttonPlayLData = new FormData();
            buttonPlayLData.width = 24;
            buttonPlayLData.height = 23;
            buttonPlayLData.left = new FormAttachment(0, 1000, 31);
            buttonPlayLData.top = new FormAttachment(0, 1000, 2);
            this.buttonPlay = new Button(parentComposite, 0x1000008);
            this.buttonPlay.setLayoutData((Object)buttonPlayLData);
            this.redrawPlayButton(this.currentActionStatus);
            this.buttonPlay.addSelectionListener((SelectionListener)new PlayButtonAdapter());
            this.buttonPlay.addMouseTrackListener((MouseTrackListener)new ButtonMouseCursorTrackAdapter());
            FormData labelTimeLinePreviewLData = new FormData();
            labelTimeLinePreviewLData.top = new FormAttachment(0, 1000, 8);
            labelTimeLinePreviewLData.right = new FormAttachment(1000, 1000, -4);
            this.timelinePreview = new Label(parentComposite, 0);
            this.timelinePreview.setLayoutData((Object)labelTimeLinePreviewLData);
            this.timelinePreview.setText("00:00/00:00");
            FormData sliderPreviewLayoutData = new FormData();
            sliderPreviewLayoutData.height = 14;
            sliderPreviewLayoutData.left = new FormAttachment(0, 1000, 60);
            sliderPreviewLayoutData.top = new FormAttachment(0, 1000, 6);
            sliderPreviewLayoutData.right = new FormAttachment((Control)this.timelinePreview, -5);
            this.sliderPreview = new Slider(parentComposite, 256);
            this.sliderPreview.setLayoutData((Object)sliderPreviewLayoutData);
            this.sliderPreview.setMinimum(0);
            this.sliderPreview.setIncrement(20);
            this.setLocationPreviewSlider(600000, 0);
            this.sliderPreview.addSelectionListener((SelectionListener)new SliderPreviewSelectionAdapter());
            this.sliderPreview.addMouseTrackListener((MouseTrackListener)new SliderMouseCursorTrackAdapter());
            eventManager.addSyncTimeEventListener(this);
            eventManager.addMouseDragEventListener(this);
            eventManager.addPlayerControlEvenListener(this);
            parentComposite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    eventManager.removeSyncTimeEventListener(ownInst);
                    eventManager.removeMouseDragEventListener(ownInst);
                    eventManager.removePlayerControlEventListener(ownInst);
                }
            });
        }
        catch (Exception e) {
            System.out.println("PreviewPanelView() : Exception = " + e);
        }
    }

    public Button getPlayButton() {
        return this.buttonPlay;
    }

    private void setLocationPreviewSlider(int movieEndTime, int currentTime) {
        this.sliderPreview.setMaximum(movieEndTime);
        this.sliderPreview.setSelection(currentTime);
        this.sliderPreview.setToolTipText(this.getStringTimeLine(currentTime, movieEndTime));
    }

    public void setEnablePlayPause(boolean stat) {
        this.buttonPlay.setEnabled(stat);
    }

    public String getURLMovie() {
        IModelService model = ModelServiceUtils.getActiveModelService();
        if (model instanceof IWebBrowserACTF) {
            return model.getURL();
        }
        return "about:blank";
    }

    public void setURLMovie(String newURL) {
        IModelService model = ModelServiceUtils.getActiveModelService();
        if (model instanceof IWebBrowserACTF) {
            ((IWebBrowserACTF)model).navigate(newURL);
        } else {
            ModelServiceUtils.launch((String)newURL, (String)WebBrowserEditor.ID);
        }
    }

    public int getVideoStatus() {
        return WebBrowserFactory.getInstance().getVideoStatus();
    }

    public int getVideoCurrentPosition() {
        return WebBrowserFactory.getInstance().getCurrentPosition();
    }

    public int getVideoTotalTime() {
        return WebBrowserFactory.getInstance().getTotalLength();
    }

    public void synchronizeTimeLine(int nowTime) {
        int movieTotalTime = instParentView.getEndTimeLine();
        this.timelinePreview.setText(this.getStringTimeLine(nowTime, movieTotalTime));
        this.setLocationPreviewSlider(movieTotalTime, nowTime);
    }

    private String getStringTimeLine(int nowTime, int endTime) {
        String strCurrentTime = new String(String.valueOf(instScriptData.makeFormatMM(nowTime)) + ":" + instScriptData.makeFormatSS(nowTime));
        String strEndTime = new String(String.valueOf(instScriptData.makeFormatMM(endTime)) + ":" + instScriptData.makeFormatSS(endTime));
        return String.valueOf(strCurrentTime) + "/" + strEndTime;
    }

    private void redrawPlayButton(int nextStatus) {
        Image imgPlay = null;
        String textToolTip = null;
        if (nextStatus == 0) {
            imgPlay = Activator.getImageDescriptor("/icons/Play.jpg").createImage();
            textToolTip = new String("Play movie");
        } else {
            imgPlay = Activator.getImageDescriptor("/icons/Pause.jpg").createImage();
            textToolTip = new String("Pause movie");
        }
        this.buttonPlay.setImage(imgPlay);
        this.buttonPlay.setToolTipText(textToolTip);
    }

    public boolean isSamplingAudioMode() {
        return this.currentSamplingAudioMode;
    }

    public void setSamplingAudioMode(boolean stat) {
        this.currentSamplingAudioMode = stat;
    }

    public boolean getCurrentStatusMedia() {
        return this.currentStatusMedia;
    }

    public void setCurrentStatusMedia(boolean newStat) {
        this.currentStatusMedia = newStat;
    }

    public int playPauseMedia() {
        this.currentActionStatus ^= 0xFFFFFFFF;
        if (this.currentActionStatus == 0) {
            SoundMixer.getInstance().stopCaptureSound();
            SoundMixer.getInstance().stopPlaySound();
            WebBrowserFactory.getInstance().pauseMedia();
            instParentView.switchActionTimeLine(false);
            instParentView.reqStopVoicePlayer();
            instParentView.reqRedrawVolumeLevelCanvas(4);
            this.setSamplingAudioMode(false);
            this.setCurrentStatusMedia(true);
        } else {
            int paintStatus;
            if (VolumeLevelCanvas.getInstance().getCurrentCaptureMode()) {
                SoundMixer.getInstance().startCaptureSound(0);
                this.setSamplingAudioMode(true);
                paintStatus = 2;
            } else {
                paintStatus = 4;
            }
            instParentView.reqRedrawVolumeLevelCanvas(paintStatus);
            WebBrowserFactory.getInstance().playMedia();
            instParentView.switchActionTimeLine(true);
            this.setCurrentStatusMedia(false);
        }
        this.redrawPlayButton(this.currentActionStatus);
        EditPanelView.getInstance().getInstanceTabEditPanel().setEnablePreview(this.currentActionStatus);
        EditPanelView.getInstance().getInstanceTabSelWAVFile().setEnablePreview(this.currentActionStatus);
        return this.currentActionStatus;
    }

    public void controlExtendedPlay(boolean stat) {
        if (stat) {
            WebBrowserFactory.getInstance().pauseMedia();
        } else {
            WebBrowserFactory.getInstance().playMedia();
        }
    }

    public void rewindMedia() {
        this.setSamplingAudioMode(false);
        instParentView.switchActionTimeLine(false);
        instParentView.rewindActionTimeLine();
        this.currentActionStatus = 0;
        this.redrawPlayButton(this.currentActionStatus);
        this.sliderPreview.setSelection(0);
        EditPanelView.getInstance().getInstanceTabEditPanel().setEnablePreview(this.currentActionStatus);
        EditPanelView.getInstance().getInstanceTabSelWAVFile().setEnablePreview(this.currentActionStatus);
        SoundMixer.getInstance().stopCaptureSound();
        SoundMixer.getInstance().stopPlaySound();
        WebBrowserFactory.getInstance().rewindMedia();
        instParentView.reqStopVoicePlayer();
        instParentView.reqRewindTimeLine();
        this.setCurrentStatusMedia(true);
    }

    public void reload() {
        instParentView.reqCleanupCaptureData();
        instParentView.reqRedrawVolumeLevelCanvas(1);
        IModelService model = ModelServiceUtils.getActiveModelService();
        if (model instanceof IWebBrowserACTF) {
            ((IWebBrowserACTF)model).navigateRefresh();
        }
        instParentView.reqStopVoicePlayer();
        this.setCurrentStatusMedia(true);
    }

    void pauseForDargging() {
        if (this.currentDragStatus) {
            return;
        }
        this.currentDragStatus = true;
        this.saveCurrentActionStatus = this.currentActionStatus;
        if (this.saveCurrentActionStatus != 0) {
            this.playPauseMedia();
        }
    }

    void resumeAfterDragging() {
        if (!this.currentDragStatus) {
            return;
        }
        if (this.saveCurrentActionStatus != 0) {
            this.playPauseMedia();
        }
        this.currentDragStatus = false;
    }

    @Override
    public void handleSyncTimeEvent(SyncTimeEvent e) {
        if (e.getEventType() == 0) {
            this.synchronizeTimeLine(e.getCurrentTime());
        } else {
            e.getEventType();
        }
    }

    @Override
    public void handleMouseDragEvent(MouseDragEvent e) {
        switch (e.getEventType()) {
            case 0: {
                this.pauseForDargging();
                break;
            }
            case 3: {
                this.currentDragStatus = e.isStatus();
                break;
            }
            case 2: {
                this.resumeAfterDragging();
            }
        }
    }

    @Override
    public void handlePlayPauseEvent(PlayerControlEvent e) {
        this.playPauseMedia();
    }

    class ButtonMouseCursorTrackAdapter
    extends MouseTrackAdapter {
        ButtonMouseCursorTrackAdapter() {
        }

        public void mouseEnter(MouseEvent e) {
            Button parentButton = (Button)e.getSource();
            parentButton.setCursor(new Cursor(null, 21));
        }

        public void mouseExit(MouseEvent e) {
            Button parentButton = (Button)e.getSource();
            parentButton.setCursor(new Cursor(null, 0));
        }
    }

    class PlayButtonAdapter
    extends SelectionAdapter {
        PlayButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            PreviewPanel.this.playPauseMedia();
        }
    }

    class RewindButtonAdapter
    extends SelectionAdapter {
        RewindButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            PreviewPanel.this.rewindMedia();
            PreviewPanel.this.setCurrentStatusMedia(true);
        }
    }

    class SliderMouseCursorTrackAdapter
    extends MouseTrackAdapter {
        SliderMouseCursorTrackAdapter() {
        }

        public void mouseEnter(MouseEvent e) {
            Slider parentSlider = (Slider)e.getSource();
            parentSlider.setCursor(new Cursor(null, 21));
        }

        public void mouseExit(MouseEvent e) {
            Slider parentSlider = (Slider)e.getSource();
            parentSlider.setCursor(new Cursor(null, 0));
        }
    }

    class SliderPreviewSelectionAdapter
    extends SelectionAdapter {
        SliderPreviewSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            Slider ps = (Slider)e.getSource();
            int currentLocation = ps.getSelection();
            if (e.detail == 1 && PreviewPanel.this.previousEventSliderPreview != 1) {
                PreviewPanel.this.previousEventSliderPreview = e.detail;
                PreviewPanel.this.previousMaxSlider = ps.getMaximum();
                PreviewPanel.this.pauseForDargging();
                eventManager.fireMouseDragEvent(new MouseDragEvent(3, PreviewPanel.this.currentDragStatus, (Object)this));
            } else if (e.detail == 0 && PreviewPanel.this.previousEventSliderPreview == 1) {
                PreviewPanel.this.previousEventSliderPreview = e.detail;
                PreviewPanel.this.resumeAfterDragging();
                eventManager.fireMouseDragEvent(new MouseDragEvent(3, PreviewPanel.this.currentDragStatus, (Object)this));
                if (PreviewPanel.this.stopExpandMaxSlider) {
                    PreviewPanel.this.stopExpandMaxSlider = false;
                    PreviewPanel.this.setLocationPreviewSlider(ps.getMaximum(), PreviewPanel.this.storeCurrentTimeLineSlider);
                }
                WebBrowserFactory.getInstance().showCurrentImage();
                return;
            }
            if (PreviewPanel.this.previousEventSliderPreview == 1 && currentLocation >= PreviewPanel.this.previousMaxSlider) {
                PreviewPanel.this.stopExpandMaxSlider = true;
                PreviewPanel.this.storeCurrentTimeLineSlider = TimeLineCanvas.getInstance().getCurrentPositionMarkerTimeLine();
            }
            if (!PreviewPanel.this.stopExpandMaxSlider) {
                instParentView.reqSetTrackCurrentTimeLine(currentLocation);
                eventManager.fireSyncTimeEvent(new SyncTimeEvent(currentLocation, (Object)this));
                WebBrowserFactory.getInstance().setCurrentPosition(currentLocation);
            }
        }
    }
}

