/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.jxpath;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.eclipse.actf.util.dom.EmptyNodeListImpl;
import org.eclipse.actf.util.jxpath.DOMExNodePointer;
import org.eclipse.actf.util.jxpath.DOMExNodePointerFactory;
import org.eclipse.actf.util.xpath.XPathService;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XPathServiceImpl
extends XPathService {
    static {
        DOMExNodePointerFactory.initialize();
    }

    public Object compile(String path) {
        return JXPathContext.compile((String)path);
    }

    public NodeList evalForNodeList(Object compiled, Node base) {
        DOMExNodePointer ptr;
        CompiledExpression ce = (CompiledExpression)compiled;
        JXPathContext bctx = JXPathContext.newContext((Object)base.getOwnerDocument());
        JXPathContext ctx = bctx.getRelativeContext((Pointer)(ptr = new DOMExNodePointer(base, null)));
        Iterator it = ce.iteratePointers(ctx);
        if (!it.hasNext()) {
            return EmptyNodeListImpl.getInstance();
        }
        ArrayList<Node> result = new ArrayList<Node>();
        do {
            Pointer pt;
            Object o;
            if (!((o = (pt = (Pointer)it.next()).getNode()) instanceof Node)) continue;
            Node n = (Node)o;
            result.add(n);
        } while (it.hasNext());
        return new NodeListImpl(result);
    }

    public String evalForString(Object compiled, Node base) {
        CompiledExpression ce = (CompiledExpression)compiled;
        JXPathContext bctx = JXPathContext.newContext((Object)base.getOwnerDocument());
        DOMExNodePointer ptr = new DOMExNodePointer(base, null);
        JXPathContext ctx = bctx.getRelativeContext((Pointer)ptr);
        return ce.getValue(ctx).toString();
    }

    public static XPathService newInstance() {
        return new XPathServiceImpl();
    }

    private XPathServiceImpl() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeListImpl
    implements NodeList {
        private List<Node> nodeList;

        @Override
        public Node item(int index) {
            if (index < 0 || index >= this.nodeList.size()) {
                return null;
            }
            return this.nodeList.get(index);
        }

        @Override
        public int getLength() {
            return this.nodeList.size();
        }

        NodeListImpl(List<Node> nodeList) {
            this.nodeList = nodeList == null ? new ArrayList<Node>(0) : nodeList;
        }
    }
}

