/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.tea.library.build.util.StreamHelper;
import org.w3c.dom.Document;

public final class FileUtils {
    public static void deleteDirectory(File directory) {
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            throw new IllegalStateException("not a directory: " + String.valueOf(directory));
        }
        List<String> ignoredFiles = Collections.emptyList();
        FileUtils.deleteDirectoryContent(directory, ignoredFiles);
        if (!directory.delete()) {
            throw new IllegalStateException("cannot delete " + String.valueOf(directory));
        }
    }

    public static void deleteDirectoryContent(File directory, List<String> ignoredFileNames) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                FileUtils.deleteDirectoryContent(child, ignoredFileNames);
            }
            if (!ignoredFileNames.contains(child.getName()) && !child.delete()) {
                throw new IllegalStateException("cannot delete " + String.valueOf(child));
            }
            ++n2;
        }
    }

    public static void copyFileToDirectory(File srcFile, File destDir) throws IOException {
        if (!destDir.isDirectory() && !destDir.mkdirs()) {
            throw new IOException("cannot create directory " + String.valueOf(destDir));
        }
        File destFile = new File(destDir, srcFile.getName());
        FileUtils.copyFile(srcFile, destFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File srcFile, File destFile) throws IOException {
        block14: {
            if (!srcFile.isFile()) {
                throw new IOException("not a file: " + String.valueOf(srcFile));
            }
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileInputStream fis = new FileInputStream(srcFile);
                try {
                    try (FileOutputStream out = new FileOutputStream(destFile);){
                        StreamHelper.copyStream(fis, out);
                    }
                    if (fis == null) break block14;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        long time = srcFile.lastModified();
        if (destFile.setLastModified(time)) return;
        throw new IOException("cannot set last modified time: " + String.valueOf(destFile));
    }

    public static void hardLinkOrCopy(File srcFile, File destFile) throws IOException {
        try {
            Files.createLink(destFile.toPath(), srcFile.toPath());
        }
        catch (Exception e) {
            FileUtils.copyFile(srcFile, destFile);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void download(String uri, File target) throws Exception {
        URL url = new URI(uri).toURL();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream is = url.openStream();
            try {
                try (FileOutputStream out = new FileOutputStream(target);){
                    ReadableByteChannel rbc = Channels.newChannel(is);
                    out.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        FileUtils.copyDirectory(srcDir, destDir, Collections.emptyList());
    }

    public static void copyDirectory(File srcDir, File destDir, List<String> exclude) throws IOException {
        if (!srcDir.isDirectory()) {
            throw new IOException("not a directory: " + String.valueOf(srcDir));
        }
        FileUtils.mkdirs(destDir);
        File[] fileArray = srcDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!exclude.contains(file.getName())) {
                if (file.isFile()) {
                    FileUtils.copyFileToDirectory(file, destDir);
                } else {
                    FileUtils.copyDirectory(file, new File(destDir, file.getName()), exclude);
                }
            }
            ++n2;
        }
    }

    public static void delete(File file) {
        if (file.exists() && !file.delete()) {
            throw new IllegalStateException("cannot delete " + String.valueOf(file));
        }
    }

    public static void mkdirs(File dir) {
        long tried = 0L;
        while (++tried <= 20L && !dir.exists()) {
            if (dir.mkdirs()) {
                return;
            }
            try {
                Thread.sleep(tried);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (dir.exists()) {
            return;
        }
        throw new IllegalStateException("cannot create " + String.valueOf(dir));
    }

    public static void writeXml(Document document, File file) throws Exception {
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(file);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.setOutputProperty("encoding", "UTF-8");
        xformer.transform(source, result);
    }

    public static Document readXml(File file) throws Exception {
        Document document;
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            document = FileUtils.readXml(is);
        }
        catch (Throwable throwable) {
            StreamHelper.closeQuietly(is);
            throw throwable;
        }
        StreamHelper.closeQuietly(is);
        return document;
    }

    public static Document readXml(InputStream stream) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        return builder.parse(stream);
    }

    public static Properties readProperties(File file) {
        try {
            Properties p = new Properties();
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                p.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return p;
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot read " + String.valueOf(file), e);
        }
    }

    public static void writeProperties(Properties props, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            props.store(fos, null);
        }
        finally {
            StreamHelper.closeQuietly(fos);
        }
    }

    public static void moveFile(File source, File target) throws IOException {
        FileUtils.delete(target);
        if (!source.renameTo(target)) {
            FileUtils.copyFile(source, target);
            FileUtils.delete(source);
        }
    }

    public static void moveDirectory(File source, File target) throws IOException {
        FileUtils.deleteDirectory(target);
        if (!source.renameTo(target)) {
            FileUtils.copyDirectory(source, target);
            FileUtils.deleteDirectory(source);
        }
    }

    public static void touchFile(File f) throws IOException {
        if (f.exists()) {
            if (!f.setLastModified(System.currentTimeMillis())) {
                throw new IOException("setting last-modified time failed");
            }
        } else if (!f.createNewFile()) {
            throw new IOException("cannot create " + String.valueOf(f));
        }
    }

    public static String readStringFromFile(File file, Charset cs) throws IOException {
        if (!file.isFile()) {
            throw new IOException("not a file: " + String.valueOf(file));
        }
        if (file.length() > Integer.MAX_VALUE) {
            throw new IOException("file is too big");
        }
        int len1 = (int)file.length();
        char[] cbuf = new char[len1];
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), cs);){
            int len2 = r.read(cbuf, 0, len1);
            return new String(cbuf, 0, len2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeFileFromString(File file, Charset cs, String contents) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), cs);){
            w.write(contents);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<String> readListFile(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException("not a file: " + String.valueOf(file));
        }
        try (FileReader reader = new FileReader(file);){
            List<String> list = FileUtils.readListFile(reader);
            return list;
        }
    }

    public static List<String> readListFile(Reader reader) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        LineNumberReader r = new LineNumberReader(reader);
        String line = r.readLine();
        while (line != null) {
            String element = line.trim();
            if (!element.isEmpty() && !element.startsWith("#")) {
                result.add(element);
            }
            line = r.readLine();
        }
        return result;
    }

    public static File safeFile(String f) {
        if (f == null) {
            return null;
        }
        File r = new File(f);
        if (!r.exists()) {
            return null;
        }
        return r;
    }

    public static boolean equals(File f1, File f2) {
        try {
            byte[] b1 = Files.readAllBytes(f1.toPath());
            byte[] b2 = Files.readAllBytes(f2.toPath());
            return Arrays.equals(b1, b2);
        }
        catch (IOException e) {
            return false;
        }
    }
}

