/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks.p2;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.updatesite.CategoryXMLAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.IFeatureRootAdvice;
import org.eclipse.equinox.p2.publisher.actions.RootIUAction;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.config.BuildDirectories;
import org.eclipse.tea.library.build.internal.Activator;
import org.eclipse.tea.library.build.jar.JarManager;
import org.eclipse.tea.library.build.model.FeatureBuild;
import org.eclipse.tea.library.build.model.FeatureData;
import org.eclipse.tea.library.build.model.PlatformTriple;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.p2.TargetPlatformHelper;
import org.eclipse.tea.library.build.p2.TeaFeatureRootAdvice;
import org.eclipse.tea.library.build.p2.TeaProductAction;
import org.eclipse.tea.library.build.p2.TeaProductDescription;
import org.eclipse.tea.library.build.p2.UpdateSite;
import org.eclipse.tea.library.build.p2.UpdateSiteCategory;
import org.eclipse.tea.library.build.p2.UpdateSiteManager;
import org.eclipse.tea.library.build.tasks.jar.TaskRunFeaturePluginJarExport;
import org.eclipse.tea.library.build.util.FileUtils;

public class TaskPublishProductUpdateSite {
    public static final String PRODUCT_VERSIONS_PROPERTIES = "productVersions.properties";
    private final String siteName;
    private final String productFeature;
    private final String productFileName;
    private final boolean composite;
    private static final String EXECUTABLE = "org.eclipse.equinox.executable";

    public TaskPublishProductUpdateSite(String siteName, String productFeature, String productFileName, boolean composite) {
        this.siteName = siteName;
        this.productFeature = productFeature;
        this.productFileName = productFileName;
        this.composite = composite;
    }

    public String toString() {
        return "Publish Product Update Site (" + this.productFeature + ')';
    }

    @Execute
    public void run(TaskingLog log, UpdateSiteManager um, WorkspaceBuild wb, JarManager jarManager, BuildDirectories dirs, IProgressMonitor mon) throws Exception {
        ITargetLocation loc;
        File featureDir = new File(dirs.getOutputDirectory(), TaskRunFeaturePluginJarExport.getFeatureJarDirectory());
        File pluginDir = new File(dirs.getOutputDirectory(), TaskRunFeaturePluginJarExport.getPluginJarDirectory());
        UpdateSite site = um.getSite(this.siteName);
        FeatureBuild feature = wb.getFeature(this.productFeature);
        if (feature == null) {
            throw new RuntimeException("Cannot find feature " + this.productFeature + "'");
        }
        Properties props = this.readProperties(feature);
        String customBin = props.getProperty("customBinaries");
        boolean hasBin = false;
        if (customBin != null) {
            hasBin = true;
        }
        LinkedHashSet<Object> featureLocations = new LinkedHashSet<Object>();
        LinkedHashSet<File> pluginLocations = new LinkedHashSet<File>();
        LinkedHashSet<File> deltaPacks = new LinkedHashSet<File>();
        featureLocations.add(featureDir);
        pluginLocations.add(pluginDir);
        ITargetDefinition targetDefinition = TargetPlatformHelper.getCurrentTargetDefinition();
        int fSize = featureLocations.size();
        ITargetLocation[] iTargetLocationArray = targetDefinition.getTargetLocations();
        int n = iTargetLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            loc = iTargetLocationArray[n2];
            if (!TaskPublishProductUpdateSite.isOK(loc.getStatus())) {
                loc.resolve(targetDefinition, mon);
            }
            ++n2;
        }
        P2TargetUtils.getIUs((ITargetDefinition)targetDefinition, (IProgressMonitor)mon);
        iTargetLocationArray = targetDefinition.getTargetLocations();
        n = iTargetLocationArray.length;
        n2 = 0;
        while (n2 < n) {
            loc = iTargetLocationArray[n2];
            if (!TaskPublishProductUpdateSite.isOK(loc.getStatus())) {
                throw new RuntimeException("Failed to resolve " + loc.getType() + "-type content for target definition '" + targetDefinition.getName() + "': " + this.getMessage(loc.getStatus()));
            }
            ++n2;
        }
        iTargetLocationArray = targetDefinition.getTargetLocations();
        n = iTargetLocationArray.length;
        n2 = 0;
        while (n2 < n) {
            TargetBundle[] targetBundles;
            Object targetLocation;
            int n3;
            loc = iTargetLocationArray[n2];
            TargetFeature[] targetFeatures = loc.getFeatures();
            if (targetFeatures != null) {
                TargetFeature[] targetFeatureArray = targetFeatures;
                n3 = targetFeatures.length;
                int n4 = 0;
                while (n4 < n3) {
                    TargetFeature targetFeature = targetFeatureArray[n4];
                    targetLocation = new File(targetFeature.getLocation());
                    if (featureLocations.add(targetLocation) && this.looksLikeDeltaFeature((File)targetLocation)) {
                        deltaPacks.add((File)targetLocation);
                    }
                    ++n4;
                }
            }
            if ((targetBundles = loc.getBundles()) != null) {
                targetLocation = targetBundles;
                int n5 = targetBundles.length;
                n3 = 0;
                while (n3 < n5) {
                    TargetBundle targetBundle = targetLocation[n3];
                    pluginLocations.add(new File(targetBundle.getBundleInfo().getLocation()));
                    ++n3;
                }
            }
            ++n2;
        }
        if (deltaPacks.isEmpty() && !hasBin) {
            throw new IllegalStateException("Cannot find delta-pack. Do you have the correct Target Platform activated?");
        }
        log.info("found " + (featureLocations.size() - fSize) + " features from target platform");
        File productFile = new File(((FeatureData)feature.getData()).getBundleDir(), this.productFileName);
        if (!productFile.exists() || !productFile.isFile()) {
            throw new RuntimeException("Cannot find product file '" + this.productFileName + "'");
        }
        TeaProductDescription productDescriptor = new TeaProductDescription(productFile, feature);
        log.info("execJarCommand: " + feature.getFeatureName());
        jarManager.execJarCommands(feature, featureDir);
        String featureVersion = ((FeatureData)feature.getData()).getBundleVersion();
        String buildVersion = jarManager.getQualifier();
        File propFile = new File(dirs.getSiteDirectory(), PRODUCT_VERSIONS_PROPERTIES);
        Properties properties = new Properties();
        properties.put("configs", PlatformTriple.getAllTargetsBuildPropStyle());
        properties.put(productDescriptor.getProductName(), buildVersion);
        properties.put(String.valueOf(productDescriptor.getProductName()) + ".release", featureVersion);
        properties.put(this.siteName, buildVersion);
        FeatureBuild.updateProperties(propFile, properties);
        log.info("Publish artifacts to update site '" + site.directory + "'");
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new FeaturesAction(featureLocations.toArray(new File[featureLocations.size()])));
        actions.add(new BundlesAction(pluginLocations.toArray(new File[pluginLocations.size()])));
        actions.add((Object)new TeaProductAction((IProductDescriptor)productDescriptor, this.getExecutablesDir(deltaPacks), hasBin ? new File(((FeatureData)feature.getData()).getBundleDir(), customBin) : null));
        actions.add(new RootIUAction(feature.getFeatureName(), Version.parseVersion((String)featureVersion), feature.getFeatureName()));
        this.addRootFiles(log);
        IPublisherInfo info = this.createPublisherInfo(log, site.directory);
        IFeatureRootAdvice rootFileAdvice = this.createRootAdvice(feature, info);
        if (rootFileAdvice != null) {
            info.addAdvice((IPublisherAdvice)rootFileAdvice);
        }
        File categoryFile = this.createCategoryFile(jarManager, wb, feature);
        actions.add(new CategoryXMLAction(categoryFile.toURI(), featureVersion));
        Publisher publisher = new Publisher(info);
        IStatus result = publisher.publish(actions.toArray(new IPublisherAction[0]), null);
        if (result.getSeverity() == 4) {
            throw new RuntimeException("Failed to publish artifacts to update site '" + result + "'");
        }
        if (!this.composite) {
            site.createUpdateSiteZip(jarManager.getZipExecFactory(), log);
        }
    }

    private static boolean isOK(IStatus status) {
        return status == null ? false : status.isOK();
    }

    private String getMessage(IStatus status) {
        return status == null ? "no status" : status.getMessage();
    }

    private boolean looksLikeDeltaFeature(File feature) {
        return feature.getName().startsWith(EXECUTABLE);
    }

    protected IFeatureRootAdvice createRootAdvice(FeatureBuild feature, IPublisherInfo info) throws Exception {
        File propertyFile = new File(((FeatureData)feature.getData()).getBundleDir(), "build.properties");
        if (!propertyFile.exists() || !propertyFile.canRead()) {
            throw new RuntimeException("Unable to find '" + propertyFile + "'");
        }
        Properties properties = FileUtils.readProperties(propertyFile);
        TeaFeatureRootAdvice advice = new TeaFeatureRootAdvice(feature, info);
        advice.addFiles(Utils.processRootProperties((Properties)properties, (boolean)false));
        return advice;
    }

    protected File createCategoryFile(JarManager jarManager, WorkspaceBuild wb, FeatureBuild feature) throws Exception {
        Properties properties = this.readProperties(feature);
        String categoryName = properties.getProperty("category");
        if (categoryName == null || categoryName.isEmpty()) {
            throw new RuntimeException("Missing 'category' entry in 'wpob.properties'");
        }
        File dirName = BuildDirectories.get().getOutputDirectory();
        File categoryFile = new File(dirName, "category.xml");
        UpdateSiteCategory.generateCategoryXml(categoryFile, Collections.singletonMap(feature.getFeatureName(), "Default"), wb, jarManager);
        return categoryFile;
    }

    private Properties readProperties(FeatureBuild feature) {
        File propertyFile = new File(((FeatureData)feature.getData()).getBundleDir(), "wpob.properties");
        if (!propertyFile.exists() || !propertyFile.canRead()) {
            throw new RuntimeException("Unable to find '" + propertyFile + "'");
        }
        Properties properties = FileUtils.readProperties(propertyFile);
        return properties;
    }

    protected File getExecutablesDir(Set<File> deltaPacks) {
        File feature = null;
        Version featureVersion = null;
        for (File candidate : deltaPacks) {
            String name = candidate.getName();
            if (!name.startsWith(EXECUTABLE)) continue;
            if (feature == null) {
                feature = candidate;
                featureVersion = Version.create((String)feature.getName().substring(name.indexOf("_") + 1));
                continue;
            }
            Version candidateVersion = Version.create((String)name.substring(name.indexOf("_") + 1));
            if (featureVersion.compareTo((Object)candidateVersion) >= 1) continue;
            feature = candidate;
            featureVersion = candidateVersion;
        }
        if (feature == null) {
            throw new IllegalArgumentException("Unable to locate executable feature 'org.eclipse.equinox.executable'");
        }
        return feature;
    }

    protected void addRootFiles(TaskingLog log) throws Exception {
    }

    protected IPublisherInfo createPublisherInfo(TaskingLog log, File repositoryPath) throws Exception {
        IArtifactRepository artifactRepository;
        IMetadataRepository metadataRepository;
        PublisherInfo info = new PublisherInfo();
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("p2.compressed", "true");
        SimpleMetadataRepositoryFactory metadataRepositoryFactory = new SimpleMetadataRepositoryFactory();
        metadataRepositoryFactory.setAgent((IProvisioningAgent)Activator.getService(IProvisioningAgent.SERVICE_NAME));
        try {
            metadataRepository = metadataRepositoryFactory.load(repositoryPath.toURI(), 1, null);
            log.debug("loaded existing metadata repostiory at " + repositoryPath);
        }
        catch (ProvisionException e) {
            metadataRepository = metadataRepositoryFactory.create(repositoryPath.toURI(), "Metadata Repository", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
        }
        SimpleArtifactRepositoryFactory artifactRepositoryFactory = new SimpleArtifactRepositoryFactory();
        artifactRepositoryFactory.setAgent((IProvisioningAgent)Activator.getService(IProvisioningAgent.SERVICE_NAME));
        try {
            artifactRepository = artifactRepositoryFactory.load(repositoryPath.toURI(), 1, null);
            log.debug("loaded existing artifact repostiory at " + repositoryPath);
        }
        catch (ProvisionException e) {
            artifactRepository = artifactRepositoryFactory.create(repositoryPath.toURI(), "Artifact Repository", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
        }
        info.setMetadataRepository(metadataRepository);
        info.setArtifactRepository(artifactRepository);
        info.setArtifactOptions(11);
        info.setConfigurations(new String[]{PlatformTriple.WIN32.toStringCmdLine(), PlatformTriple.WIN64.toStringCmdLine(), PlatformTriple.LINUX32.toStringCmdLine(), PlatformTriple.LINUX64.toStringCmdLine()});
        return info;
    }
}

