/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.lcdsl.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tea.library.build.chain.TeaBuildElement;
import org.eclipse.tea.library.build.util.TeaBuildUtil;
import org.eclipse.xtext.ui.XtextProjectHelper;

public class TeaLcDslElement
extends TeaBuildElement {
    static final String NAME_PRE = "LcDsl: Prepare launch configurations";
    static final String NAME_POST = "LcDsl: Update launch configurations";
    private final List<IProject> projects = new ArrayList<IProject>();
    private final String name;

    public TeaLcDslElement(String name) {
        this.name = name;
    }

    public void add(IProject toBuild) {
        this.projects.add(toBuild);
    }

    public void execute() {
        TeaBuildUtil.tryCompile(this.projects);
    }

    public String getName() {
        return this.name;
    }

    static boolean hasLc(IProject prj) {
        if (XtextProjectHelper.hasNature((IProject)prj)) {
            AtomicBoolean hasLc = new AtomicBoolean();
            try {
                prj.accept(res -> {
                    if (hasLc.get()) {
                        return false;
                    }
                    if (res.getType() == 2 || res.getType() == 4) {
                        return true;
                    }
                    if (res.getType() == 1 && res.getName().endsWith(".lc")) {
                        hasLc.set(true);
                    }
                    return false;
                });
            }
            catch (CoreException e) {
                throw new RuntimeException("cannot visit " + prj + "'s resources", e);
            }
            return hasLc.get();
        }
        return false;
    }
}

