/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;

public class ShiftMessagesOperation
extends AbstractModelChangeOperation<Void> {
    protected final boolean move;
    protected final Collection<Message> messagesToShift = new ArrayList<Message>();
    protected final Collection<ISequenceEvent> movedElements = new HashSet<ISequenceEvent>();
    protected final int deltaY;
    private final boolean revert;

    protected ShiftMessagesOperation(String name, int deltaY, boolean revert, boolean move) {
        super(name);
        this.deltaY = deltaY;
        this.revert = revert;
        this.move = move;
    }

    public ShiftMessagesOperation(Collection<Message> messagesToShift, Collection<ISequenceEvent> movedElements, int deltaY, boolean revert, boolean move) {
        this(Messages.ShiftMessagesOperation_operationName, deltaY, revert, move);
        this.messagesToShift.addAll(Objects.requireNonNull(messagesToShift));
        this.movedElements.addAll(Objects.requireNonNull(movedElements));
    }

    public Void execute() {
        for (Message smep : this.messagesToShift) {
            this.shiftBendpoints(smep);
        }
        return null;
    }

    private void shiftBendpoints(Message message) {
        boolean needShiftFromSrc = this.needShift(message, true);
        boolean needShiftFromTgt = this.needShift(message, false);
        Edge edge = (Edge)message.getNotationView();
        int currentSourceDeltaY = 0;
        int currentTargetDeltaY = 0;
        int srcShift = this.getDeltaY(edge, false);
        if (needShiftFromSrc) {
            currentSourceDeltaY = this.revert ? 0 : srcShift;
            currentTargetDeltaY = this.revert ? srcShift : 0;
        }
        int tgtShift = this.getDeltaY(edge, true);
        if (needShiftFromTgt) {
            currentTargetDeltaY = this.revert ? currentTargetDeltaY : tgtShift;
            currentSourceDeltaY = this.revert ? tgtShift : currentSourceDeltaY;
        }
        RelativeBendpoints bp = (RelativeBendpoints)edge.getBendpoints();
        List oldPoints = bp.getPoints();
        ArrayList<RelativeBendpoint> newPoints = new ArrayList<RelativeBendpoint>();
        int i = 0;
        while (i < oldPoints.size()) {
            RelativeBendpoint old = (RelativeBendpoint)oldPoints.get(i);
            newPoints.add(new RelativeBendpoint(old.getSourceX(), old.getSourceY() + currentSourceDeltaY, old.getTargetX(), old.getTargetY() + currentTargetDeltaY));
            ++i;
        }
        bp.setPoints(newPoints);
    }

    private boolean needShift(Message message, boolean source) {
        boolean reverted;
        boolean moved;
        boolean movedBySrc = this.movedElements.contains(message.getSourceElement());
        boolean movedByTgt = this.movedElements.contains(message.getTargetElement());
        boolean bl = moved = movedBySrc || movedByTgt;
        if (this.move && !this.revert) {
            boolean bl2 = moved = moved || this.movedElements.contains(message);
        }
        boolean shiftedEnd = source ? !movedBySrc : !movedByTgt;
        boolean bl3 = reverted = this.revert && movedBySrc && movedByTgt;
        return moved && (shiftedEnd || reverted);
    }

    protected int getDeltaY(Edge edge, boolean source) {
        return this.deltaY;
    }
}

