/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;

public class IFileQuery {
    private IFile file;

    public IFileQuery(IFile file) {
        this.file = file;
    }

    public boolean isResourceHandledByOpenedSession() {
        boolean result = false;
        URI fileURI = URI.createPlatformResourceURI((String)this.file.getFullPath().toString(), (boolean)true);
        for (Session session : new ArrayList<Session>(SessionManager.INSTANCE.getSessions())) {
            if (!session.isOpen() || fileURI == null) continue;
            Iterable handledResources = Iterables.concat(session.getSemanticResources(), session.getReferencedSessionResources());
            if (session instanceof DAnalysisSessionEObject) {
                handledResources = Iterables.concat((Iterable)handledResources, (Iterable)((DAnalysisSessionEObject)session).getControlledResources());
            }
            Iterator iterator = handledResources.iterator();
            while (iterator.hasNext() && !result) {
                Resource res = (Resource)iterator.next();
                if (!fileURI.equals(res.getURI())) continue;
                result = true;
            }
        }
        return result;
    }
}

