/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.editor.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.resource.strategy.ResourceStrategyRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ui.editor.SessionEditor;
import org.eclipse.sirius.ui.editor.SessionEditorPlugin;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class ModelCommonDropAdapterAssistant
extends CommonDropAdapterAssistant {
    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        Collection<IFile> droppedModelFiles;
        Optional<Session> session;
        if (2 == operation && (session = this.findCurrentSession()).isPresent() && session.get().getSemanticResources().stream().allMatch(res -> res.getURI().isPlatformResource()) && !(droppedModelFiles = this.collectDroppedSemanticModelCandidates(LocalSelectionTransfer.getTransfer().getSelection(), session.get())).isEmpty()) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        Collection<IFile> droppedModelFiles;
        IStatus status = Status.CANCEL_STATUS;
        final Optional<Session> session = this.findCurrentSession();
        if (session.isPresent() && !(droppedModelFiles = this.collectDroppedSemanticModelCandidates(aDropTargetEvent.data, session.get())).isEmpty()) {
            try {
                new ProgressMonitorDialog(this.getShell()).run(false, false, monitor -> {
                    TransactionalEditingDomain ted = ((Session)session.get()).getTransactionalEditingDomain();
                    ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                        protected void doExecute() {
                            droppedModelFiles.forEach(file -> ((Session)session.get()).addSemanticResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), monitor));
                        }
                    });
                });
                status = Status.OK_STATUS;
            }
            catch (InterruptedException | InvocationTargetException e) {
                SessionEditorPlugin.getPlugin().error(e.getMessage(), e);
            }
        }
        return status;
    }

    private Optional<Session> findCurrentSession() {
        IEditorPart activeEditor = EclipseUIUtil.getActiveEditor();
        if (activeEditor instanceof SessionEditor) {
            return Optional.ofNullable(((SessionEditor)activeEditor).getSession());
        }
        return Optional.empty();
    }

    private Collection<IFile> collectDroppedSemanticModelCandidates(Object object, Session session) {
        if (object instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)object).toList();
            return list.stream().filter(IFile.class::isInstance).map(IFile.class::cast).filter(f -> this.isLoadableSemanticModel((IFile)f, session)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean isLoadableSemanticModel(IFile file, Session session) {
        URI candidateURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        ResourceStrategyRegistry rsr = ResourceStrategyRegistry.getInstance();
        return rsr.isPotentialSemanticResource(candidateURI) && rsr.isLoadableModel(candidateURI, session);
    }
}

